﻿## SA1207

<table>
<tr>
  <td>TypeName</td>
  <td>SA1207ProtectedMustComeBeforeInternal</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1207</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

The keyword *protected* is positioned after the keyword *internal* within the declaration of a protected internal C# element, or the keyword *private* is positioned after the keyword *protected*.

## Rule description

A violation of this rule occurs when a protected internal element's access modifiers are written as *internal protected*, or when a private protected element's access modifiers are written as *protected private*. In reality, an element with the keywords *protected internal* will have the same access level as an element with the keywords *internal protected*. To make the code easier to read and more consistent, StyleCop standardizes the ordering of these keywords, so that a protected internal element will always be described as such, and never as internal protected. This can help to reduce confusion about whether these access levels are indeed the same.

## How to fix violations

To fix an instance of this violation, place the *protected* keyword before the *internal* keyword, or place the *private* keyword before the *protected* keyword.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1207:ProtectedMustComeBeforeInternal", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1207 // ProtectedMustComeBeforeInternal
#pragma warning restore SA1207 // ProtectedMustComeBeforeInternal
```
