﻿## SA1400

<table>
<tr>
  <td>TypeName</td>
  <td>SA1400AccessModifierMustBeDeclared</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1400</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

## Cause

The access modifier for a C# element has not been explicitly defined.

## Rule description

C# allows elements to be defined without an access modifier. Depending upon the type of element, C# will automatically assign an access level to the element in this case.

This rule requires an access modifier to be explicitly defined for every element. This removes the need for the reader to make assumptions about the code, improving the readability of the code.

## How to fix violations

To fix a violation of this rule, add an access modifier to the declaration of the element.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1400:AccessModifierMustBeDeclared", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1400 // AccessModifierMustBeDeclared
#pragma warning restore SA1400 // AccessModifierMustBeDeclared
```
