<h2>Why is this an issue?</h2>
<p>Shared coding conventions make it possible for a team to efficiently collaborate. This rule makes it mandatory to place a close curly brace at the
beginning of a line.</p>
<h3>Noncompliant code example</h3>

```java
if(condition) {
  doSomething();}
```
<h3>Compliant solution</h3>

```java
if(condition) {
  doSomething();
}
```
<h3>Exceptions</h3>
<p>When blocks are inlined (open and close curly braces on the same line), no issue is triggered.</p>

```java
if(condition) {doSomething();}
```