<h2>Why is this an issue?</h2>
<p><code>notify</code> and <code>notifyAll</code> both wake up sleeping threads waiting on the object’s monitor, but <code>notify</code> only wakes up
one single thread, while <code>notifyAll</code> wakes them all up. Unless you do not care which specific thread is woken up, <code>notifyAll</code>
should be used instead.</p>
<h3>Noncompliant code example</h3>

```java
class MyThread implements Runnable {
  Object lock = new Object();

  @Override
  public void run() {
    synchronized(lock) {
      // ...
      lock.notify();  // Noncompliant
    }
  }
}
```
<h3>Compliant solution</h3>

```java
class MyThread implements Runnable {
  Object lock = new Object();

  @Override
  public void run() {
    synchronized(lock) {
      // ...
      lock.notifyAll();
    }
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/MTdGBQ">CERT, THI02-J.</a> - Notify all waiting threads rather than a single thread </li>
</ul>