<h2>Why is this an issue?</h2>
<p>The repetition of a unary operator is usually a typo. The second operator invalidates the first one in most cases:</p>

```java
int i = 1;

int j = - - -i;  // Noncompliant: equivalent to "-i"
int k = ~~~i;    // Noncompliant: equivalent to "~i"
int m = + +i;    // Noncompliant: equivalent to "i"

boolean b = false;
boolean c = !!!b;   // Noncompliant
```
<p>On the other hand, while repeating the increment and decrement operators is technically correct, it obfuscates the meaning:</p>

```java
int i = 1;
int j = ++ ++i;  // Noncompliant
int k = i-- --; // Noncompliant
```
<p>Using <code>+=</code> or <code>-=</code> improves readability:</p>

```java
int i = 1;
i += 2;
int j = i;
int k = i;
i -=2;
```
<p>This rule raises an issue for repetitions of <code>!</code>, <code>~</code>, <code>-</code>, <code>+</code>, prefix increments <code>++</code> and
prefix decrements <code>--</code>.</p>
<h3>Exceptions</h3>
<p>Overflow handling for GWT compilation using <code>~~</code> is ignored.</p>