<h2>Why is this an issue?</h2>
<p>Shadowing makes it impossible to use the type parameter from the outer scope. Also, it can be confusing to distinguish which type parameter is
being used.</p>
<p>This rule raises an issue when a type parameter from an inner scope uses the same name as one in an outer scope.</p>
<h3>Noncompliant code example</h3>

```java
 public class TypeParameterHidesAnotherType<T> {

    public class Inner<T> { // Noncompliant
      //...
    }

    private <T> T method() { // Noncompliant
      return null;
    }

  }
```
<h3>Compliant solution</h3>

```java
public class NoTypeParameterHiding<T> {

    public class Inner<S> { // Compliant
      List<S> listOfS;
    }

    private <V> V method() { // Compliant
      return null;
    }

  }
```