<h2>Why is this an issue?</h2>
<p>The <code>var</code> statement declares variables that are function-scoped or globally-scoped. <code>var</code> declarations are hoisted, meaning
declaring a variable anywhere in the code is equivalent to declaring it at the top of the function or the script.</p>
<p>Even if hoisted, it is still recommended to declare the variable inside the block it is used. This improves readability and maintainability because
it makes it clear where the variable is being used. The code then becomes easier to understand and follow, especially for other developers who may be
working on the same codebase.</p>

```js
function doSomething(a, b) {
  if (a > b) {
    var x = a - b;  // Noncompliant: 'x' is used later outside this block
  }

  if (a > 4) {
    console.log(x);
  }

  for (var i = 0; i < m; i++) { // Noncompliant: both loops use same variable
  }

  for (var i = 0; i < n; i++) {
  }

  return a + b;
}
```
<p>When <code>var</code> declaration is used outside of a block, the declaration should be done at the uppermost level where it is used. When
possible, use <code>let</code> or <code>const</code>, which allow for block-scoped variables.</p>

```js
function doSomething(a, b) {
  var x;

  if (a > b) {
    x = a - b;
  }

  if (a > 4) {
    console.log(x);
  }

  for (let i = 0; i < m; i++) {
  }

  for (let i = 0; i < n; i++) {
  }


  return a + b;
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Scope">Scope</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/var"><code>var</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Hoisting">Hoisting</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/const">const</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/let">let</a> </li>
</ul>