<h2>Why is this an issue?</h2>
<p>The value of <code>this</code> depends on which context it appears:</p>
<ul>
  <li> Function: The value of <code>this</code> will depend on how a function was called. The value of <code>this</code> is not always the object that
  has the function as an <em>own</em> property, but the object that is used to call the function. The methods <code>Function.prototype.call()</code>,
  <code>Function.prototype.apply()</code>, or <code>Reflect.apply()</code> can be used to explicitly set the value of <code>this</code>. Is it also
  possible to create a new function with a specific value of this that doesn’t change regardless of how the function is called with
  <code>Function.prototype.bind()</code>. In non-strict mode, <code>this</code> will always be an object and will default to <code>globalThis</code>
  if set to <code>undefined</code> or <code>null</code>. </li>
  <li> Arrow function: The value of <code>this</code> will be the same as the enclosing context. Arrow functions will not create a new
  <code>this</code> binding. When invoking arrow functions using <code>call()</code>, <code>bind()</code>, or <code>apply()</code>, the
  <code>thisArg</code> parameter is ignored. </li>
  <li> Class: Class methods behave like methods in other objects: the <code>this</code> value is the object that the method was accessed on. If the
  method is not transferred to another object, <code>this</code> is generally an instance of the class. However, for static methods, the value of
  <code>this</code> is the class instead of the instance. </li>
  <li> Global: outside of any functions or classes (also inside blocks or arrow functions defined in the global scope), the value of <code>this</code>
  depends on what execution context the script runs in. </li>
</ul>
<p>When a function is called without an explicit object context, the <code>this</code> keyword refers to the global object. This also applies when it
is used outside of an object or function. The global <code>this</code> object refers to the global context in which the JavaScript code is executed.
This can cause problems when the code is executed in different contexts, such as in a browser or in a Node.js environment, where the global object is
different. Such uses could confuse maintainers as the actual value depends on the execution context, and it can be unclear what object the
<code>this</code> keyword is referring to.</p>
<p>In JavaScript’s "strict mode", using <code>this</code> in the global context will always be <code>undefined</code>.</p>

```js
this.foo = 1;   // Noncompliant: 'this' refers to global 'this'
console.log(this.foo); // Noncompliant: 'this' refers to global 'this'

function MyObj() {
  this.foo = 1; // Compliant
}

MyObj.func1 = function() {
  if (this.foo === 1) { // Compliant
    // ...
  }
}
```
<p>Instead, simply drop the <code>this</code>, or replace it with <code>globalThis</code>. The <code>globalThis</code> global property gives access to
the global object regardless of the current environment.</p>

```js
foo = 1;
console.log(foo);

function MyObj() {
  this.foo = 1;
}

MyObj.func1 = function() {
  if (this.foo === 1) {
    // ...
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/this#global_context">this</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode#no_this_substitution">No this
  substitution</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/globalThis">globalThis</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Global_object">Global object</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode">Strict mode</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Reflect/apply">Reflect.apply()</a>
  </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/call">Function.prototype.call()</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/apply">Function.prototype.apply()</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/bind">Function.prototype.bind()</a> </li>
</ul>