<h2>Why is this an issue?</h2>
<p>When merging objects or copying properties from one object to another, use the object spread syntax instead of <code>Object.assign()</code>. The
object spread syntax was introduced in ES2018 and allows shallow-cloning or merging of objects with a more concise and readable syntax.</p>
<p>The <code>Object.assign()</code> also allows to mutate an object, which is not possible with the spread syntax, so the rule only applies to cases
where the first argument of the <code>Object.assign()</code> is an object literal.</p>
<p>The object spread syntax improves clarity when you’re modifying an object, as demonstrated in this example: <code>foo = { bar: 42, …​baz }</code>.
Additionally, it provides a more concise way to perform a shallow clone. Instead of using <code>foo = Object.assign({}, bar)</code>, you can simply
write <code>foo = { …​bar }</code>.</p>

```js
const a = Object.assign({}, foo); // Noncompliant: Use spread syntax to clone or merge objects
const b = Object.assign({}, foo, bar); // Noncompliant: Use spread syntax to clone or merge objects
const c = Object.assign({foo: 123}, bar); // Noncompliant: Use spread syntax to clone or merge objects
const d = Object.assign({}); // Noncompliant: Use spread syntax to clone or merge objects
```
<p>To fix the code replace <code>Object.assign()</code> with a spread syntax.</p>

```js
const a = {...foo};
const b = {...foo, ...bar};
const c = {foo: 123, ...bar};
const d = {};
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Spread_syntax#spread_in_object_literals">Spread in object
  literals</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Object/assign"><code>Object.assign()</code></a> </li>
</ul>