<h2>Why is this an issue?</h2>
<p>Jump statements, such as <code>return</code>, <code>goto</code>, and <code>continue</code> let you change the default flow of program execution,
but jump statements that direct the control flow to the original direction are just a waste of keystrokes.</p>
<h3>Noncompliant code example</h3>

```php
function foo($p) {
  $i = $p;
  while ($i > 0) {
    $i--;
    continue; // Noncompliant
  }
}
```
<h3>Compliant solution</h3>

```php
function foo($p) {
  $i = $p;
  while ($i > 0) {
    $i--;
  }
}
```