<h2>Why is this an issue?</h2>
<p>Two methods having the same implementation are suspicious. It might be that something else was intended. Or the duplication is intentional, which
becomes a maintenance burden.</p>

```php
class A {
    private const CODE = "secret";

    public function getCode() {
        doTheThing();
        return A::CODE;
    }

    public function getName() {  // Noncompliant: duplicates getCode
        doTheThing();
        return A::CODE;
    }
}
```
<p>If the identical logic is intentional, the code should be refactored to avoid duplication. For example, by having both methods call the same method
or by having one implementation invoke the other.</p>

```php
class A {
    private const CODE = "secret";

    public function getCode() {
        doTheThing();
        return A::CODE;
    }

    public function getName() { // Intent is clear
        return $this->getCode();
    }
}
```
<h3>Exceptions</h3>
<p>Methods that are not accessors (getters and setters), with fewer than 2 statements are ignored.</p>
<p>Additionally, accessors consisting of a single statement are ignored, if this statement does one of the following:</p>
<ul>
  <li> Return <code>null</code> or an empty list <code>[]</code> </li>
  <li> Throw an exception </li>
  <li> Return a newly created object </li>
</ul>