import{_ as i,c as t,ak as a,o as l}from"./chunks/framework.AfHpRKMk.js";const s="/assets/eclipse-preferences.ImfM0hDJ.png",n="/assets/eclipse-precommit3.CvI6nsyR.png",f=JSON.parse('{"title":"Integrating with Eclipse","description":"","frontmatter":{"title":"Integrating with Eclipse"},"headers":[],"relativePath":"howto/integrating-with-your-ide/eclipse/index.md","filePath":"howto/integrating-with-your-ide/eclipse/index.md"}'),o={name:"howto/integrating-with-your-ide/eclipse/index.md"};function r(c,e,h,p,m,d){return l(),t("div",null,[...e[0]||(e[0]=[a('<h1 id="teamscale-integration-for-eclipse" tabindex="-1">Teamscale Integration for Eclipse <a class="header-anchor" href="#teamscale-integration-for-eclipse" aria-label="Permalink to &quot;Teamscale Integration for Eclipse&quot;">​</a></h1><p>Teamscale integrates with <a href="https://eclipseide.org/" target="_blank" rel="noreferrer">Eclipse</a>, including dedicated support for the <a href="https://tools.hana.ondemand.com/#abap" target="_blank" rel="noreferrer">ABAP Development Tools for Eclipse</a> Before installing the <em>Teamscale Integration for Eclipse</em>, make sure its <a href="./../../../reference/system-requirements/#system-requirements-for-ide-plugins">system requirements</a> are met.</p><nav class="table-of-contents"><ul><li><a href="#installing-the-plug-in">Installing the Plug-in</a><ul><li><a href="#installing-the-latest-version-from-the-eclipse-marketplace-recommended">Installing the Latest Version From the Eclipse Marketplace (recommended)</a></li><li><a href="#installing-any-version-from-the-cqse-website">Installing Any Version From the CQSE Website</a></li><li><a href="#installing-while-offline">Installing While Offline</a></li></ul></li><li><a href="#connecting-to-teamscale">Connecting to Teamscale</a><ul><li><a href="#configuring-using-teamscale-toml-files">Configuring Using .teamscale.toml Files</a></li></ul></li><li><a href="#performing-pre-commit-analysis">Performing Pre-Commit Analysis</a></li></ul></nav><h2 id="installing-the-plug-in" tabindex="-1">Installing the Plug-in <a class="header-anchor" href="#installing-the-plug-in" aria-label="Permalink to &quot;Installing the Plug-in&quot;">​</a></h2><p>Depending on your needs, there are several options to install the <em>Teamscale Integration for Eclipse</em>.</p><h3 id="installing-the-latest-version-from-the-eclipse-marketplace-recommended" tabindex="-1">Installing the Latest Version From the Eclipse Marketplace (recommended) <a class="header-anchor" href="#installing-the-latest-version-from-the-eclipse-marketplace-recommended" aria-label="Permalink to &quot;Installing the Latest Version From the Eclipse Marketplace (recommended)&quot;">​</a></h3><p>For most users, installing the <strong>latest version</strong> of the plug-in from the <a href="https://marketplace.eclipse.org/content/teamscale-integration-eclipse" target="_blank" rel="noreferrer">Eclipse Marketplace</a> is recommended.</p><ol><li>Open the <a href="https://marketplace.eclipse.org/content/teamscale-eclipse-plugin" target="_blank" rel="noreferrer"><em>Teamscale Integration for Eclipse</em> solution page</a> at the Eclipse Marketplace.</li><li>Drag the <em>Install</em> button from the solution page onto your running Eclipse workspace. This opens the installation wizard.</li><li>Follow the instructions of the installation wizard</li><li>Restart Eclipse when prompted.</li></ol><h3 id="installing-any-version-from-the-cqse-website" tabindex="-1">Installing Any Version From the CQSE Website <a class="header-anchor" href="#installing-any-version-from-the-cqse-website" aria-label="Permalink to &quot;Installing Any Version From the CQSE Website&quot;">​</a></h3><p>Unlike the Eclipse Marketplace, the CQSE website offers both the <strong>latest version</strong> and <strong>older versions</strong> of the plug-in.</p><ol><li>Select <em>Help</em> &gt; <em>Install New Software...</em> from the Eclipse menu bar.</li><li>Enter a <em>Work with</em> location. <ul><li><strong>Latest Version:</strong> <code>https://downloads.teamscale.com/ide/eclipse/latest/</code></li><li><strong>Older Version:</strong> <code>https://downloads.teamscale.com/ide/eclipse/vM.N.x/</code> (replacing <code>M.N</code> by the feature version you need but keeping the <code>.x</code>, e.g., <code>7.8.x</code>)</li></ul></li><li>Select <em>Teamscale Integration for Eclipse</em> and any optional features you want.</li><li>Click <em>Next</em> and follow the instructions of the installation wizard.</li><li>Restart Eclipse when prompted.</li></ol><h3 id="installing-while-offline" tabindex="-1">Installing While Offline <a class="header-anchor" href="#installing-while-offline" aria-label="Permalink to &quot;Installing While Offline&quot;">​</a></h3><p>In case you cannot reach the Eclipse Marketplace or CQSE Website during the installation, e.g., due to a security policy, you can perform an offline installation.</p><ol><li>Download an archive of the update site from the CQSE website. <ul><li><strong>Latest Version:</strong> <a href="https://www.cqse.eu/download/teamscale/ide/eclipse/latest/teamscale-eclipse-update-site.zip" target="_blank" rel="noreferrer"><code>https://downloads.teamscale.com/ide/eclipse/latest/teamscale-eclipse-update-site.zip</code></a></li><li><strong>Specific Version:</strong> <code>https://downloads.teamscale.com/ide/eclipse/vM.N.x/teamscale-eclipse-update-site.zip</code> (replacing <code>M.N</code> by the feature version you need but keeping the <code>.x</code>, e.g., <code>7.8.x</code>)</li></ul></li><li>Transfer the downloaded archive to your offline computer.</li><li>Select <em>Help</em> &gt; <em>Install New Software...</em> from the Eclipse menu bar.</li><li>Click <em>Add</em> and the <em>Archive</em>.</li><li>Select the downloaded archive.</li><li>Select <em>Teamscale Integration for Eclipse</em> and any optional features you want.</li><li>Click <em>Next</em> and follow the instructions of the installation wizard. (If this step fails, see the <a href="./../../../troubleshooting/#cannot-install-eclipse-integration">troubleshooting guide</a>.)</li><li>Restart Eclipse when prompted.</li></ol><div class="tip custom-block"><p class="custom-block-title">Installing on the Command Line</p><p>You can perform the offline installation on the command line as well.</p><ol><li>Unzip the downloaded archive.</li><li>Use the Eclipse <a href="http://help.eclipse.org/latest/index.jsp?topic=/org.eclipse.platform.doc.isv/guide/p2_director.html" target="_blank" rel="noreferrer">p2 director</a> to install.<div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">eclipse</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -nosplash</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -application</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> org.eclipse.equinox.p2.director</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -repository</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> file:///path/to/teamscale-eclipse-update-site</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -installIU</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> com.teamscale.ide</span></span></code></pre></div></li><li>(If you ever need to uninstall the plug-in, you can use the p2 director as well.)<div class="language-bash vp-adaptive-theme"><button title="Copy Code" class="copy"></button><span class="lang">bash</span><pre class="shiki shiki-themes github-light github-dark vp-code" tabindex="0"><code><span class="line"><span style="--shiki-light:#6F42C1;--shiki-dark:#B392F0;">eclipse</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -nosplash</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -application</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> org.eclipse.equinox.p2.director</span><span style="--shiki-light:#005CC5;--shiki-dark:#79B8FF;"> -uninstallIU</span><span style="--shiki-light:#032F62;--shiki-dark:#9ECBFF;"> com.teamscale.ide</span></span></code></pre></div></li></ol></div><div class="warning custom-block"><p class="custom-block-title">Don&#39;t Use Eclipse&#39;s Dropins Mechanism</p><p>With the <a href="https://wiki.eclipse.org/Equinox/p2/Getting_Started#Dropins" target="_blank" rel="noreferrer">dropins</a> folder, Eclipse provides another way of installing plug-ins. We (and the Eclipse team) discourage using it for installing plug-ins unless you absolutely need to. You won&#39;t get error messages with the dropins mechanism as you would with the p2 director, e.g., in case of missing dependencies.</p></div><h2 id="connecting-to-teamscale" tabindex="-1">Connecting to Teamscale <a class="header-anchor" href="#connecting-to-teamscale" aria-label="Permalink to &quot;Connecting to Teamscale&quot;">​</a></h2><p>After installing the plug-in, you need to perform the following actions to configure a Teamscale server:</p><ol><li>Open the Eclipse preferences dialog, navigate to the Teamscale settings (<em>Window</em> &gt; <em>Preferences...</em> &gt; <em>Teamscale</em>) and click on <em>Add</em></li><li>Enter a descriptive name and the URL of the Teamscale server</li><li>Enter your <em>Username</em> and <a href="./../../../glossary/#access-key"><em>Access Key</em></a><img src="'+s+'" alt="Eclipse Server Settings" width="800" height="536" data-zoom="true"></li><li>Test the connection by clicking on <em>Validate</em>.</li><li>Close the dialog by pressing <em>OK</em>.</li></ol><h3 id="configuring-using-teamscale-toml-files" tabindex="-1">Configuring Using <code>.teamscale.toml</code> Files <a class="header-anchor" href="#configuring-using-teamscale-toml-files" aria-label="Permalink to &quot;Configuring Using `.teamscale.toml` Files&quot;">​</a></h3><p>In addition to connecting to a Teamscale server, the local Eclipse projects need to be mapped to projects on the Teamscale server. Since Teamscale 9.9, this is done using one or more <code>.teamscale.toml</code> configuration files in a simple, uniform <a href="./../../../reference/teamscale-toml/">file format (<code>.teamscale.toml</code>)</a>.</p><p>The only exception are ABAP projects, which are still configured using the ABAP projects&#39; <em>Properties</em>.</p><h2 id="performing-pre-commit-analysis" tabindex="-1">Performing Pre-Commit Analysis <a class="header-anchor" href="#performing-pre-commit-analysis" aria-label="Permalink to &quot;Performing Pre-Commit Analysis&quot;">​</a></h2><p>The Eclipse plug-in can be used to analyze changes prior to committing them to the repository. This functionality is called pre-commit analysis. The findings of these pre-commits are shown as any other finding in the <em>Findings</em> tool window. The <em>Automatic Pre-Commit Analysis</em> option under the Teamscale tab must be enabled: <img src="'+n+'" alt="Teamscale Pre-Commit" width="843" height="153" data-zoom="true"></p><p>The pre-commit analysis is started automatically when you do one of the following actions:</p><ul><li>Open a file in the editor</li><li>Switch to an already open file in the editor</li><li>Save the file currently active editor</li><li>Save all open files</li><li>Activate ABAP code</li></ul><p>Under the hood, Teamscale treats these changes as a commit on a new, virtual branch: your pre-commit branch. Eclipse will poll the Teamscale server until analysis of this commit is done. Once analysis is finished, Teamscale will show the findings from your pre-commit branch.</p><p>Note that, by default, the Teamscale server enforces some limits on the pre-commit branch w.r.t. to the number of files that may be included in each pre-commit. These limits exist so that one overly large pre-commit upload does not disproportionately delay analysis of other commits. More information is <a href="./../../../reference/admin-settings/server-limits/#pre-commit-limits">available here</a> .</p>',28)])])}const u=i(o,[["render",r]]);export{f as __pageData,u as default};
