import{_ as a}from"./chunks/helm_chart_code_view_link.CP4ZW735.js";import{_ as t,c as i,ak as s,o as n}from"./chunks/framework.AfHpRKMk.js";const o="/assets/parser_error.Bn4gC7Jc.png",l="/assets/advanced_options.BObpIttf.png",r="/assets/full_manifest_toggle.QSaTsnVY.png",c="/assets/original_file_content_toggle.BlSC3p35.png",h="/assets/kustomization_code_view_link.wIfksY9k.png",d="/assets/other_files_link.DW9yDGwn.png",v=JSON.parse('{"title":"Kubernetes Analysis","description":"","frontmatter":{"title":"Kubernetes Analysis"},"headers":[],"relativePath":"howto/kubernetes-analysis/index.md","filePath":"howto/kubernetes-analysis/index.md"}'),f={name:"howto/kubernetes-analysis/index.md"};function u(m,e,p,g,b,y){return n(),i("div",null,[...e[0]||(e[0]=[s('<h1 id="analysis-of-kubernetes-resources" tabindex="-1">Analysis of Kubernetes Resources <a class="header-anchor" href="#analysis-of-kubernetes-resources" aria-label="Permalink to &quot;Analysis of Kubernetes Resources&quot;">​</a></h1><p>Setting up the analysis of Kubernetes resources is similar to the analysis for other technologies in Teamscale. Information about specifics to the Kubernetes analysis is provided in this article.</p><nav class="table-of-contents"><ul><li><a href="#helm-charts-kustomizations-static-manifests">Helm Charts, Kustomizations, Static Manifests</a></li><li><a href="#project-creation-and-analysis-setup">Project Creation and Analysis Setup</a><ul><li><a href="#analyzing-all-relevant-files">Analyzing all Relevant Files</a></li><li><a href="#helm-values-files">Helm Values Files</a></li></ul></li><li><a href="#web-ui-features-for-kubernetes-resources">Web UI Features for Kubernetes Resources</a><ul><li><a href="#toggle-between-full-manifest-and-original-file">Toggle between Full Manifest and Original File</a></li><li><a href="#find-origin-locations-of-findings">Find Origin Locations of Findings</a></li></ul></li></ul></nav><h2 id="helm-charts-kustomizations-static-manifests" tabindex="-1">Helm Charts, Kustomizations, Static Manifests <a class="header-anchor" href="#helm-charts-kustomizations-static-manifests" aria-label="Permalink to &quot;Helm Charts, Kustomizations, Static Manifests&quot;">​</a></h2><p>Kubernetes resources can either be provided as static manifests or built using frameworks such as <a href="https://helm.sh/" target="_blank" rel="noreferrer">Helm</a> or <a href="https://kustomize.io/" target="_blank" rel="noreferrer">Kustomize</a>. Teamscale automatically detects if a given resource should be analyzed as (part of a) Kustomization or Helm chart, or as static manifest by itself:</p><ul><li>All Kubernetes resource files in a folder containing a <code>Chart.yaml</code> and its subfolders will be analyzed as one Helm chart.</li><li>All files referenced (transitively) by one or more <code>kustomization.yaml</code> files, are analyzed as part of the respective Kustomization(s).</li><li>All files that are neither part of a Helm chart nor of a Kustomization are analyzed as static manifests.</li></ul><p>For Helm charts and Kustomizations, Teamscale analyzes the full manifest that is built from all included resources. Resources that are part of a Helm chart or are referenced by a Kustomization are not analyzed by themselves, but only in context of the Helm chart or Kustomization that references them. Static manifests are analyzed by themselves without any additional steps.</p><p>In case of incorrect configuration in Helm charts or Kustomizations, e.g., referenced files do not exist, Teamscale may fail to build the full manifest. This is indicated by a corresponding message in the code view and an entry in the right sidebar under <em>Parsing issue found!</em>.</p><p><img src="'+o+'" alt="parser_error.png" width="2954" height="426" data-zoom="true"></p><p>The analysis will be skipped and Teamscale will not compute a findings churn for the affected manifests until a valid configuration is restored.</p><h2 id="project-creation-and-analysis-setup" tabindex="-1">Project Creation and Analysis Setup <a class="header-anchor" href="#project-creation-and-analysis-setup" aria-label="Permalink to &quot;Project Creation and Analysis Setup&quot;">​</a></h2><p>Teamscale comes with a <em>Kubernetes (default)</em> analysis profile containing a set of activated checks that should be a good starting point for most projects. This analysis profile can be <a href="./../../howto/editing-an-analysis-profile/#how-to-edit-an-analysis-profile">adjusted</a> according to your needs or a new analysis profile for the language Kubernetes can be <a href="./../../howto/creating-an-analysis-profile/#how-to-create-an-analysis-profile">created</a>. The following Kubernetes-specific aspects must be considered in addition to the general <a href="./../../howto/creating-a-project/">project setup</a> .</p><h3 id="analyzing-all-relevant-files" tabindex="-1">Analyzing all Relevant Files <a class="header-anchor" href="#analyzing-all-relevant-files" aria-label="Permalink to &quot;Analyzing all Relevant Files&quot;">​</a></h3><p>By default, when selecting a Kubernetes analysis profile for a Teamscale project, all <code>yaml</code> and <code>json</code> files are included in the analysis. However, in general, it is also possible to reference other file types, such as, <code>txt</code> files from Kustomizations or Helm charts. If this is the case, you need to adjust the patterns in the <em>Included file names</em> field in the project creation/edit view. You can start with the pattern <code>**.*</code> to include all files in the configured connector and then, if necessary, narrow down the pattern to the relevant files again.</p><h3 id="helm-values-files" tabindex="-1">Helm Values Files <a class="header-anchor" href="#helm-values-files" aria-label="Permalink to &quot;Helm Values Files&quot;">​</a></h3><p>This section is not relevant if the project only contains plain manifests or Kustomizations. For Helm charts, the following additional steps are required for the project creation.</p><p>The Helm framework provides a templating mechanism that allows to inject values into Helm charts from <a href="https://helm.sh/docs/chart_template_guide/values_files/" target="_blank" rel="noreferrer">values files</a>. An essential benefit of this is that different values files can exist in the project to cover different use cases. Teamscale needs to receive a full set of required values to be able to correctly analyze the Helm charts. With the default configuration, you can add all required values yaml files to a &quot;teamscale&quot; folder inside the Helm chart folder.</p><p>You can adjust the location of the values files to be included in the analysis profile:</p><ul><li>Go to <em>Project Configuration</em> &gt; <em>Analysis Profile</em>.</li><li>Click <em>Edit</em> on the Kubernetes analysis profile that should be used.</li><li>Click <em>Advanced Options</em>.</li><li>Adjust the options <em>Helm values folder</em> and <em>Helm value files regex</em>: <ul><li><em>Helm values folder</em> specifies the path relative to the Helm chart folder which should be used to look for values files.</li><li><em>Helm value files regex</em> is a regular expression that specifies which files in the <em>Helm values folder</em> to consider when building the Helm chart for the static analysis.</li></ul></li></ul><p><img src="'+l+'" alt="advanced_options.png" width="643" height="498" data-zoom="true"></p><h2 id="web-ui-features-for-kubernetes-resources" tabindex="-1">Web UI Features for Kubernetes Resources <a class="header-anchor" href="#web-ui-features-for-kubernetes-resources" aria-label="Permalink to &quot;Web UI Features for Kubernetes Resources&quot;">​</a></h2><p>This section provides an overview of how the Teamscale UI helps to navigate through the analysis results for Kubernetes resources.</p><h3 id="toggle-between-full-manifest-and-original-file" tabindex="-1">Toggle between Full Manifest and Original File <a class="header-anchor" href="#toggle-between-full-manifest-and-original-file" aria-label="Permalink to &quot;Toggle between Full Manifest and Original File&quot;">​</a></h3><p>For root Helm charts and root Kustomizations (i.e. Helm charts or Kustomizations that are not referenced by any other Helm charts or Kustomizations), Teamscale builds the corresponding full manifests before it analyzes them. The findings from the static analysis are assigned to lines in the full manifest. By default, the code view (<em>Metrics</em> &gt; <em>Files</em>) displays the full manifests built from those Helm charts or Kustomizations rather than the original file content of the <code>Chart.yaml</code> or <code>kustomization.yaml</code>. For the root <code>Chart.yaml</code> or <code>kustomization.yaml</code>, the code view provides a link on the top which allows switching to the <em>Original file content</em>:</p><p><img src="'+r+'" alt="full_manifest_toggle.png" width="2610" height="202" data-zoom="true"></p><p>And back to the <em>Full Kubernetes manifest</em>:</p><p><img src="'+c+'" alt="original_file_content_toggle.png" width="2610" height="202" data-zoom="true"></p><h3 id="find-origin-locations-of-findings" tabindex="-1">Find Origin Locations of Findings <a class="header-anchor" href="#find-origin-locations-of-findings" aria-label="Permalink to &quot;Find Origin Locations of Findings&quot;">​</a></h3><p>Findings in full manifests for Helm charts and Kustomizations often need to be fixed in one of the referenced resources. Teamscale supports the navigation to the referenced resources in the code view and the finding details view.</p><h4 id="code-view" tabindex="-1">Code View <a class="header-anchor" href="#code-view" aria-label="Permalink to &quot;Code View&quot;">​</a></h4><p>For Helm charts, the link can be found in the <em>Source</em> comment at the beginning of a section: <img src="'+a+'" alt="helm_chart_code_view_link.png" width="692" height="442" data-zoom="true"></p><p>For Kustomizations, the link can be found in the origin annotations under <em>path</em>: <img src="'+h+'" alt="kustomization_code_view_link.png" width="575" height="325"></p><h4 id="finding-details-view" tabindex="-1">Finding Details View <a class="header-anchor" href="#finding-details-view" aria-label="Permalink to &quot;Finding Details View&quot;">​</a></h4><p>The finding details view provides a link to the file where the affected section of the full manifest is defined. This link can be found under <em>Other files</em> beside the finding location below the finding description.</p><p><img src="'+d+'" alt="other_files_link.png" width="1102" height="720" data-zoom="true"></p>',35)])])}const k=t(f,[["render",u]]);export{v as __pageData,k as default};
