/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.IOException;
import java.nio.CharBuffer;
import us.hebi.matlab.mat.format.BufferAllocator;
import us.hebi.matlab.mat.format.CharEncoding;
import us.hebi.matlab.mat.format.Compat;
import us.hebi.matlab.mat.format.Mat5Serializable;
import us.hebi.matlab.mat.format.Mat5WriteUtil;
import us.hebi.matlab.mat.types.AbstractCharBase;
import us.hebi.matlab.mat.types.Sink;
import us.hebi.matlab.mat.util.Preconditions;

class MatChar
extends AbstractCharBase
implements Mat5Serializable {
    protected final CharBuffer buffer;
    protected final CharEncoding encoding;
    protected final CharEncoding.CloseableCharBuffer resource;

    MatChar(int[] dims, CharEncoding encoding, BufferAllocator bufferAllocator) {
        this(dims, encoding, CharEncoding.CloseableCharBuffer.allocate(bufferAllocator, MatChar.getNumElements(dims), ' '));
    }

    MatChar(int[] dims, CharEncoding encoding, CharEncoding.CloseableCharBuffer buffer) {
        super(dims);
        this.buffer = Preconditions.checkNotNull(buffer.chars);
        this.encoding = Preconditions.checkNotNull(encoding);
        this.resource = buffer;
        Preconditions.checkArgument(buffer.chars.remaining() == this.getNumElements(), "Unexpected number of elements");
    }

    @Override
    public CharSequence asCharSequence() {
        return this.buffer.slice();
    }

    @Override
    public char getChar(int index) {
        return this.buffer.get(index);
    }

    @Override
    public void setChar(int index, char value) {
        this.buffer.put(index, value);
    }

    @Override
    public void close() {
        this.resource.close();
    }

    @Override
    public int getMat5Size(String name) {
        this.buffer.rewind();
        return 8 + Mat5WriteUtil.computeArrayHeaderSize(name, this) + Mat5WriteUtil.computeCharBufferSize(this.encoding, this.buffer);
    }

    @Override
    public void writeMat5(String name, boolean isGlobal, Sink sink) throws IOException {
        this.buffer.rewind();
        Mat5WriteUtil.writeMatrixTag(name, this, sink);
        Mat5WriteUtil.writeArrayHeader(name, isGlobal, this, sink);
        Mat5WriteUtil.writeCharBufferWithTag(this.encoding, this.buffer, sink);
    }

    @Override
    protected int subHashCode() {
        return Compat.hash(new Object[]{this.buffer, this.encoding});
    }

    @Override
    protected boolean subEqualsGuaranteedSameClass(Object otherGuaranteedSameClass) {
        MatChar other = (MatChar)otherGuaranteedSameClass;
        return other.buffer.equals(this.buffer);
    }
}

