/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.types;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import us.hebi.matlab.mat.types.Source;
import us.hebi.matlab.mat.types.Sources;
import us.hebi.matlab.mat.util.ByteConverter;
import us.hebi.matlab.mat.util.ByteConverters;
import us.hebi.matlab.mat.util.Bytes;

public abstract class AbstractSource
implements Source {
    private ByteOrder byteOrder = null;
    private final byte[] bytes;
    private static final ByteConverter byteConverter = ByteConverters.getFastest();

    @Override
    public AbstractSource order(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        return this;
    }

    @Override
    public ByteOrder order() {
        if (this.byteOrder == null) {
            throw new IllegalStateException("Byte order has not been initialized");
        }
        return this.byteOrder;
    }

    @Override
    public byte readByte() throws IOException {
        this.readBytes(this.bytes, 0, 1);
        return this.bytes[0];
    }

    @Override
    public short readShort() throws IOException {
        this.readBytes(this.bytes, 0, 2);
        return byteConverter.getShort(this.order(), this.bytes, 0);
    }

    @Override
    public int readInt() throws IOException {
        this.readBytes(this.bytes, 0, 4);
        return byteConverter.getInt(this.order(), this.bytes, 0);
    }

    @Override
    public long readLong() throws IOException {
        this.readBytes(this.bytes, 0, 8);
        return byteConverter.getLong(this.order(), this.bytes, 0);
    }

    @Override
    public float readFloat() throws IOException {
        this.readBytes(this.bytes, 0, 4);
        return byteConverter.getFloat(this.order(), this.bytes, 0);
    }

    @Override
    public double readDouble() throws IOException {
        this.readBytes(this.bytes, 0, 8);
        return byteConverter.getDouble(this.order(), this.bytes, 0);
    }

    @Override
    public void readByteBuffer(ByteBuffer buffer) throws IOException {
        if (buffer.hasArray()) {
            int offset = buffer.arrayOffset() + buffer.position();
            int length = buffer.remaining();
            this.readBytes(buffer.array(), offset, length);
            buffer.position(buffer.limit());
        } else {
            while (buffer.hasRemaining()) {
                int length = Math.min(buffer.remaining(), this.bytes.length);
                this.readBytes(this.bytes, 0, length);
                buffer.put(this.bytes, 0, length);
            }
        }
    }

    @Override
    public void readShorts(short[] buffer, int offset, int length) throws IOException {
        int i = 0;
        while (i < length) {
            int n = Math.min((length - i) * 2, this.bytes.length);
            this.readBytes(this.bytes, 0, n);
            int j = 0;
            while (j < n) {
                buffer[offset + i] = byteConverter.getShort(this.order(), this.bytes, j);
                j += 2;
                ++i;
            }
        }
    }

    @Override
    public void readInts(int[] buffer, int offset, int length) throws IOException {
        int i = 0;
        while (i < length) {
            int n = Math.min((length - i) * 4, this.bytes.length);
            this.readBytes(this.bytes, 0, n);
            int j = 0;
            while (j < n) {
                buffer[offset + i] = byteConverter.getInt(this.order(), this.bytes, j);
                j += 4;
                ++i;
            }
        }
    }

    @Override
    public void readLongs(long[] buffer, int offset, int length) throws IOException {
        int i = 0;
        while (i < length) {
            int n = Math.min((length - i) * 8, this.bytes.length);
            this.readBytes(this.bytes, 0, n);
            int j = 0;
            while (j < n) {
                buffer[offset + i] = byteConverter.getLong(this.order(), this.bytes, j);
                j += 8;
                ++i;
            }
        }
    }

    @Override
    public void readFloats(float[] buffer, int offset, int length) throws IOException {
        int i = 0;
        while (i < length) {
            int n = Math.min((length - i) * 4, this.bytes.length);
            this.readBytes(this.bytes, 0, n);
            int j = 0;
            while (j < n) {
                buffer[offset + i] = byteConverter.getFloat(this.order(), this.bytes, j);
                j += 4;
                ++i;
            }
        }
    }

    @Override
    public void readDoubles(double[] buffer, int offset, int length) throws IOException {
        int i = 0;
        while (i < length) {
            int n = Math.min((length - i) * 8, this.bytes.length);
            this.readBytes(this.bytes, 0, n);
            int j = 0;
            while (j < n) {
                buffer[offset + i] = byteConverter.getDouble(this.order(), this.bytes, j);
                j += 8;
                ++i;
            }
        }
    }

    @Override
    public void skip(long numBytes) throws IOException {
        long count;
        for (long n = 0L; n < numBytes; n += count) {
            count = Math.min(numBytes - n, (long)this.bytes.length);
            this.readBytes(this.bytes, 0, (int)count);
        }
    }

    @Override
    public Source readInflated(int numBytes, int inflateBufferSize) throws IOException {
        InputStream subInputStream = this.readBytesAsStream(numBytes);
        InflaterInputStream inflaterInput = new InflaterInputStream(subInputStream, new Inflater(), inflateBufferSize);
        return Sources.wrapInputStream(inflaterInput, this.bytes.length).order(this.order());
    }

    protected abstract InputStream readBytesAsStream(long var1) throws IOException;

    protected AbstractSource(int bufferSize) {
        int size = Math.max(Bytes.nextPowerOfTwo(bufferSize), 128);
        this.bytes = new byte[size];
    }
}

