/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.cache;

import com.teamscale.service.framework.impl.cache.CacheEntry;
import com.teamscale.service.framework.impl.cache.ServerCache;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.glassfish.jersey.message.internal.HeaderValueException;

public class ServerCacheHitFilter
implements ContainerRequestFilter {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ServerCache cache = ServerCache.getInstance();
    @Context
    private Request request;

    public void filter(ContainerRequestContext request) {
        String key = request.getUriInfo().getRequestUri().toString();
        if (request.getMethod().equalsIgnoreCase("GET")) {
            this.handleGET(request, key);
        } else if (!request.getMethod().equalsIgnoreCase("HEAD")) {
            this.cache.remove(key);
        }
    }

    private void handleGET(ContainerRequestContext request, String key) {
        CacheEntry entry;
        List<MediaType> acceptableMediaTypes = request.getAcceptableMediaTypes();
        if (CollectionUtils.isNullOrEmpty((Collection)acceptableMediaTypes)) {
            acceptableMediaTypes = Collections.singletonList(MediaType.WILDCARD_TYPE);
        }
        if ((entry = this.cache.get(key, acceptableMediaTypes, (MultivaluedMap<String, String>)request.getHeaders())) == null) {
            return;
        }
        if (entry.isExpired()) {
            this.cache.remove(key);
        } else {
            this.handleCacheHit(request, entry);
        }
    }

    private void handleCacheHit(ContainerRequestContext request, CacheEntry entry) {
        request.setProperty("DO NOT CACHE AND ENCODE RESPONSE", (Object)true);
        Response.ResponseBuilder builder = ServerCacheHitFilter.safeEvaluatePreconditions(entry.getEtag(), this.request);
        CacheControl cc = new CacheControl();
        cc.setMaxAge(entry.getExpirationInSeconds());
        if (builder != null) {
            ServerCacheHitFilter.appendCachedHeaders(entry, builder);
            request.abortWith(builder.cacheControl(cc).build());
            return;
        }
        builder = Response.ok();
        builder.entity((Object)entry.getResponse());
        ServerCacheHitFilter.appendCachedHeaders(entry, builder);
        builder.cacheControl(cc);
        request.abortWith(builder.build());
    }

    private static void appendCachedHeaders(CacheEntry entry, Response.ResponseBuilder builder) {
        for (Map.Entry header : entry.getHeaders().entrySet()) {
            for (Object val : (List)header.getValue()) {
                builder.header((String)header.getKey(), val);
            }
        }
    }

    protected static Response.ResponseBuilder safeEvaluatePreconditions(EntityTag eTag, Request request) {
        try {
            return request.evaluatePreconditions(eTag);
        }
        catch (HeaderValueException e) {
            LOGGER.warn("Failed to evaluate request headers against cached entry.", (Throwable)e);
            return null;
        }
    }
}

