/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.handler;

import com.teamscale.core.ai.AiEngineUsageIndex;
import com.teamscale.core.ai.DefaultAiEngineProvider;
import com.teamscale.core.ai.IAiEngineProvider;
import com.teamscale.core.authenticate.AuthenticationRequestHandler;
import com.teamscale.core.authenticate.SsoRedirectionHandler;
import com.teamscale.core.authenticate.index.OAuthStateIndex;
import com.teamscale.core.config.ServerConfiguration;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.permissions.PermissionCache;
import com.teamscale.core.permissions.PermissionIndex;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.UserPermissionsProvider;
import com.teamscale.core.runtime.impl.worker.MultiThreadedReadsStorageSystemProviderDecorator;
import com.teamscale.core.user.ProjectUserActivityIndex;
import com.teamscale.core.user.User;
import com.teamscale.core.user.UserGroupIndex;
import com.teamscale.core.user.UserLastActivityIndex;
import com.teamscale.index.service_log.ServiceLoadIndex;
import com.teamscale.index.usage_data.UserAgentsIndex;
import com.teamscale.service.framework.IServiceProfiler;
import com.teamscale.service.framework.IServiceStatisticsRecorder;
import com.teamscale.service.framework.IStaticServiceContext;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.impl.handler.ServiceStatisticsRecorder;
import com.teamscale.service.framework.impl.handler.TeamscaleServiceInfo;
import jakarta.ws.rs.NotFoundException;
import java.net.URI;
import java.util.Optional;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.cache.StorageCacheConfiguration;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.IStorageSystemProviderDecorator;
import org.conqat.engine.persistence.store.StorageException;

public class StaticServiceContext
implements IStaticServiceContext {
    private final IndexLayer indexLayer;
    private final UserGroupIndex userGroupIndex;
    private final PermissionIndex permissionIndex;
    private final ProjectIndex projectIndex;
    private final MetaIndex metaIndex;
    private final ServerConfiguration serverConfiguration;
    private final AuthenticationRequestHandler authenticationRequestHandler;
    private final SsoRedirectionHandler ssoRedirectionHandler;
    private final ServiceStatisticsRecorder statisticsRecorder;
    private final ILockProvider lockProvider;
    private final IAiEngineProvider aiEngineProvider;

    public StaticServiceContext(IndexLayer indexLayer, ServerConfiguration serverConfiguration, ILockProvider lockProvider) throws StorageException {
        this.indexLayer = indexLayer.decorate((IStorageSystemProviderDecorator)new MultiThreadedReadsStorageSystemProviderDecorator());
        GlobalStorageSystem globalStorageSystem = indexLayer.openGlobalStorageSystem();
        this.metaIndex = (MetaIndex)globalStorageSystem.openGlobalIndex(MetaIndex.class);
        this.userGroupIndex = (UserGroupIndex)globalStorageSystem.openGlobalIndex(UserGroupIndex.class);
        this.permissionIndex = (PermissionIndex)globalStorageSystem.openGlobalIndex(PermissionIndex.class);
        ProjectUserActivityIndex projectActivityIndex = (ProjectUserActivityIndex)globalStorageSystem.openGlobalIndex(ProjectUserActivityIndex.class);
        this.projectIndex = (ProjectIndex)globalStorageSystem.openGlobalIndex(ProjectIndex.class);
        this.serverConfiguration = serverConfiguration;
        this.authenticationRequestHandler = new AuthenticationRequestHandler(globalStorageSystem, StaticServiceContext.determinePort(serverConfiguration), serverConfiguration, this.indexLayer.getMessageBroker());
        ServerOptionIndex serverOptionIndex = (ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class);
        OAuthStateIndex oAuthStateIndex = (OAuthStateIndex)globalStorageSystem.openGlobalIndex(OAuthStateIndex.class);
        this.ssoRedirectionHandler = new SsoRedirectionHandler(serverOptionIndex, oAuthStateIndex);
        ServiceLoadIndex loadIndex = (ServiceLoadIndex)globalStorageSystem.openGlobalIndex(ServiceLoadIndex.class);
        UserLastActivityIndex userLastActivityIndex = (UserLastActivityIndex)globalStorageSystem.openGlobalIndex(UserLastActivityIndex.class);
        UserAgentsIndex userAgentsIndex = (UserAgentsIndex)globalStorageSystem.openGlobalIndex(UserAgentsIndex.class);
        this.statisticsRecorder = new ServiceStatisticsRecorder(loadIndex, userLastActivityIndex, projectActivityIndex, this.projectIndex, userAgentsIndex);
        this.lockProvider = lockProvider;
        this.aiEngineProvider = new DefaultAiEngineProvider((ServerOptionIndex)globalStorageSystem.openGlobalIndex(ServerOptionIndex.class), (AiEngineUsageIndex)globalStorageSystem.openGlobalIndex(AiEngineUsageIndex.class), indexLayer.getMessageBroker());
    }

    private static int determinePort(ServerConfiguration serverConfiguration) {
        int httpPort = serverConfiguration.getHttpPort();
        if (httpPort == 0) {
            return serverConfiguration.getHttpsPort();
        }
        return httpPort;
    }

    public ITeamscaleServiceInfo constructServiceInfo(IProjectId projectId, User user, IServiceProfiler profilingSupport, StorageCacheConfiguration cacheConfiguration, boolean noProjectStorageSystem, URI baseUri) throws StorageException {
        UserPermissionsProvider userPermissionsProvider = new UserPermissionsProvider(this.userGroupIndex, this.permissionIndex, this.indexLayer.getStorageCacheProvider().getCacheProvider("__global__").getCacheAccess(PermissionCache.class));
        ServicePermissions permissions = new ServicePermissions(userPermissionsProvider.getUserPermissions(user), projectId, this.projectIndex, this.permissionIndex);
        PublicProjectId publicProjectId = null;
        InternalProjectId internalProjectId = null;
        if (projectId != null) {
            Optional projectInfo = this.projectIndex.tryResolveProject(projectId);
            if (projectInfo.isPresent()) {
                publicProjectId = ((ProjectInfo)projectInfo.get()).getPrimaryPublicId();
                internalProjectId = ((ProjectInfo)projectInfo.get()).getInternalId();
            } else {
                throw new NotFoundException(String.format("Could not find a project with ID %s.", projectId));
            }
        }
        return new TeamscaleServiceInfo(permissions, this.indexLayer.decorate((IStorageSystemProviderDecorator)profilingSupport), internalProjectId, publicProjectId, user, this.serverConfiguration, this.lockProvider, cacheConfiguration, noProjectStorageSystem, this.serverConfiguration.isServiceLogIncludeUsers(), this.authenticationRequestHandler, baseUri, this.aiEngineProvider);
    }

    public AuthenticationRequestHandler getAuthenticationRequestHandler() {
        return this.authenticationRequestHandler;
    }

    public SsoRedirectionHandler getSsoRedirectionHandler() {
        return this.ssoRedirectionHandler;
    }

    public IServiceStatisticsRecorder getServiceStatisticsRecorder() {
        return this.statisticsRecorder;
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public IndexLayer getIndexLayer() {
        return this.indexLayer;
    }

    public MetaIndex getMetaIndex() {
        return this.metaIndex;
    }

    public ProjectIndex getProjectIndex() {
        return this.projectIndex;
    }

    public IAiEngineProvider getAiEngineProvider() {
        return this.aiEngineProvider;
    }
}

