/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.provider;

import com.teamscale.core.user.User;
import com.teamscale.service.framework.IServiceProfiler;
import com.teamscale.service.framework.IStaticServiceContext;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.NoProjectStorageSystem;
import com.teamscale.service.framework.cache.ReadCacheEnabled;
import com.teamscale.service.framework.impl.authentication.AuthenticationFilter;
import com.teamscale.service.framework.impl.factory.ServiceInfoFactory;
import com.teamscale.service.framework.impl.logging.ServiceLogHandlerUtils;
import com.teamscale.service.framework.impl.util.ForwardedHeaderUtils;
import com.teamscale.service.framework.util.ServiceAnnotationUtils;
import jakarta.annotation.Priority;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.net.URI;
import java.util.Objects;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.cache.StorageCacheConfiguration;
import org.conqat.engine.persistence.store.SchemaNotFoundException;
import org.conqat.engine.persistence.store.StorageException;

@Provider
@Priority(value=1002)
public class ServiceInfoProvider
implements ContainerRequestFilter {
    @Context
    private IStaticServiceContext staticServiceContext;
    @Context
    private ResourceInfo resourceInfo;
    @Context
    private IServiceProfiler serviceProfiler;

    public void filter(ContainerRequestContext requestContext) {
        IProjectId projectId = ServiceLogHandlerUtils.determineProject(requestContext);
        try {
            User user = AuthenticationFilter.getUser(requestContext);
            URI baseUri = ForwardedHeaderUtils.getBaseUri(requestContext);
            boolean noProjectStorageSystem = ServiceAnnotationUtils.getMethodAnnotation((ResourceInfo)this.resourceInfo, NoProjectStorageSystem.class).isPresent();
            ITeamscaleServiceInfo serviceInfo = this.staticServiceContext.constructServiceInfo(projectId, user, this.serviceProfiler, ServiceInfoProvider.buildCacheConfiguration(this.resourceInfo), noProjectStorageSystem, baseUri);
            ServiceInfoFactory.attachTo(requestContext, serviceInfo);
        }
        catch (SchemaNotFoundException e) {
            throw new NotFoundException("Project " + String.valueOf(projectId) + " doesn't exist or you don\u2019t have the necessary permissions!", (Throwable)e);
        }
        catch (StorageException e) {
            throw new InternalServerErrorException("Could not create service due to storage problems: " + e.getMessage(), (Throwable)e);
        }
    }

    private static StorageCacheConfiguration buildCacheConfiguration(ResourceInfo resourceInfo) {
        return Stream.of(resourceInfo.getResourceMethod(), resourceInfo.getResourceClass()).map(info -> info.getAnnotation(ReadCacheEnabled.class)).filter(Objects::nonNull).findFirst().map(readCacheEnabled -> new StorageCacheConfiguration(true, true, readCacheEnabled.maximumStoreCacheSize())).orElse(StorageCacheConfiguration.NO_CACHING);
    }
}

