/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.wssecurity.impl;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.shared.xml.QNameSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.soap.wssecurity.Created;
import org.opensaml.soap.wssecurity.Expires;
import org.opensaml.soap.wssecurity.Timestamp;
import org.opensaml.soap.wssecurity.impl.AbstractWSSecurityObjectUnmarshaller;
import org.w3c.dom.Attr;

public class TimestampUnmarshaller
extends AbstractWSSecurityObjectUnmarshaller {
    protected void processChildElement(@Nonnull XMLObject parentXMLObject, @Nonnull XMLObject childXMLObject) throws UnmarshallingException {
        Timestamp timestamp = (Timestamp)parentXMLObject;
        if (childXMLObject instanceof Created) {
            timestamp.setCreated((Created)childXMLObject);
        } else if (childXMLObject instanceof Expires) {
            timestamp.setExpires((Expires)childXMLObject);
        } else {
            timestamp.getUnknownXMLObjects().add(childXMLObject);
        }
    }

    protected void processAttribute(@Nonnull XMLObject xmlObject, @Nonnull Attr attribute) throws UnmarshallingException {
        Timestamp timestamp = (Timestamp)xmlObject;
        QName attrName = QNameSupport.constructQName((String)attribute.getNamespaceURI(), (String)attribute.getLocalName(), (String)attribute.getPrefix());
        if (Timestamp.WSU_ID_ATTR_NAME.equals(attrName)) {
            timestamp.setWSUId(attribute.getValue());
            attribute.getOwnerElement().setIdAttributeNode(attribute, true);
        } else {
            XMLObjectSupport.unmarshallToAttributeMap((AttributeMap)timestamp.getUnknownAttributes(), (Attr)attribute);
        }
    }
}

