/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.internal.apachecommons.lang3.StringUtils;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.rule.Severity;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.Preconditions;

@ServerSide
@ExtensionPoint
public interface BuiltInQualityProfilesDefinition {
    public void define(Context var1);

    @Immutable
    public static class OverriddenParam {
        private final String key;
        private final String overriddenValue;

        private OverriddenParam(NewOverriddenParam newOverriddenParam) {
            this.key = newOverriddenParam.key();
            this.overriddenValue = newOverriddenParam.overriddenValue;
        }

        public String key() {
            return this.key;
        }

        @Nullable
        public String overriddenValue() {
            return this.overriddenValue;
        }
    }

    public static class NewOverriddenParam {
        private final String key;
        private String overriddenValue;

        private NewOverriddenParam(String key) {
            this.key = key;
        }

        public String key() {
            return this.key;
        }

        public NewOverriddenParam setOverriddenValue(@Nullable String s) {
            this.overriddenValue = StringUtils.defaultIfEmpty(s, null);
            return this;
        }
    }

    @Immutable
    public static class BuiltInActiveRule {
        private final String repoKey;
        private final String ruleKey;
        private final String overriddenSeverity;
        private final Map<String, OverriddenParam> overriddenParams;

        private BuiltInActiveRule(NewBuiltInActiveRule newBuiltInActiveRule) {
            this.repoKey = newBuiltInActiveRule.repoKey();
            this.ruleKey = newBuiltInActiveRule.ruleKey();
            this.overriddenSeverity = newBuiltInActiveRule.overriddenSeverity;
            HashMap<String, OverriddenParam> paramsBuilder = new HashMap<String, OverriddenParam>();
            for (NewOverriddenParam newParam : newBuiltInActiveRule.getOverriddenParams()) {
                paramsBuilder.put(newParam.key, new OverriddenParam(newParam));
            }
            this.overriddenParams = Collections.unmodifiableMap(paramsBuilder);
        }

        public String repoKey() {
            return this.repoKey;
        }

        public String ruleKey() {
            return this.ruleKey;
        }

        @CheckForNull
        public String overriddenSeverity() {
            return this.overriddenSeverity;
        }

        @CheckForNull
        public OverriddenParam overriddenParam(String key) {
            return this.overriddenParams.get(key);
        }

        public List<OverriddenParam> overriddenParams() {
            return Collections.unmodifiableList(new ArrayList<OverriddenParam>(this.overriddenParams.values()));
        }

        public String toString() {
            return String.format("[repository=%s, key=%s]", this.repoKey, this.ruleKey);
        }
    }

    public static class NewBuiltInActiveRule {
        private final String repoKey;
        private final String ruleKey;
        private String overriddenSeverity = null;
        private final Map<String, NewOverriddenParam> paramsByKey = new HashMap<String, NewOverriddenParam>();

        private NewBuiltInActiveRule(String repoKey, String ruleKey) {
            this.repoKey = repoKey;
            this.ruleKey = ruleKey;
        }

        public String repoKey() {
            return this.repoKey;
        }

        public String ruleKey() {
            return this.ruleKey;
        }

        public NewBuiltInActiveRule overrideSeverity(String severity) {
            Preconditions.checkArgument(Severity.ALL.contains(severity), "Severity of rule %s is not correct: %s", RuleKey.of(this.repoKey, this.ruleKey), severity);
            this.overriddenSeverity = severity;
            return this;
        }

        public NewOverriddenParam overrideParam(String paramKey, @Nullable String value) {
            Preconditions.checkArgument(!this.paramsByKey.containsKey(paramKey), "The parameter '%s' was already overridden on the built in active rule %s", paramKey, this);
            NewOverriddenParam param = new NewOverriddenParam(paramKey).setOverriddenValue(value);
            this.paramsByKey.put(paramKey, param);
            return param;
        }

        public Collection<NewOverriddenParam> getOverriddenParams() {
            return this.paramsByKey.values();
        }

        public String toString() {
            return String.format("[repository=%s, key=%s]", this.repoKey, this.ruleKey);
        }
    }

    @Immutable
    public static class BuiltInQualityProfileImpl
    implements BuiltInQualityProfile {
        private final String language;
        private final String name;
        private final boolean isDefault;
        private final Map<RuleKey, BuiltInActiveRule> activeRulesByKey;

        private BuiltInQualityProfileImpl(NewBuiltInQualityProfileImpl newProfile) {
            this.name = newProfile.name();
            this.language = newProfile.language();
            this.isDefault = newProfile.isDefault();
            HashMap<RuleKey, BuiltInActiveRule> ruleBuilder = new HashMap<RuleKey, BuiltInActiveRule>();
            for (NewBuiltInActiveRule newActiveRule : newProfile.activeRules()) {
                ruleBuilder.put(RuleKey.of(newActiveRule.repoKey, newActiveRule.ruleKey), new BuiltInActiveRule(newActiveRule));
            }
            this.activeRulesByKey = Collections.unmodifiableMap(ruleBuilder);
        }

        @Override
        public String language() {
            return this.language;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        @Override
        @CheckForNull
        public BuiltInActiveRule rule(RuleKey ruleKey) {
            return this.activeRulesByKey.get(ruleKey);
        }

        @Override
        public List<BuiltInActiveRule> rules() {
            return Collections.unmodifiableList(new ArrayList<BuiltInActiveRule>(this.activeRulesByKey.values()));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuiltInQualityProfileImpl that = (BuiltInQualityProfileImpl)o;
            return this.language.equals(that.language) && this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.language.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("BuiltInQualityProfile{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", language='").append(this.language).append('\'');
            sb.append(", default='").append(this.isDefault).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static interface BuiltInQualityProfile {
        public String name();

        public String language();

        public boolean isDefault();

        @CheckForNull
        public BuiltInActiveRule rule(RuleKey var1);

        public List<BuiltInActiveRule> rules();
    }

    public static class NewBuiltInQualityProfileImpl
    implements NewBuiltInQualityProfile {
        private final Context context;
        private final String name;
        private final String language;
        private boolean isDefault;
        private final Map<RuleKey, NewBuiltInActiveRule> newActiveRules = new HashMap<RuleKey, NewBuiltInActiveRule>();

        private NewBuiltInQualityProfileImpl(Context context, String name, String language) {
            this.context = context;
            this.name = name;
            this.language = language;
        }

        @Override
        public NewBuiltInQualityProfile setDefault(boolean value) {
            this.isDefault = value;
            return this;
        }

        @Override
        public NewBuiltInActiveRule activateRule(String repoKey, String ruleKey) {
            RuleKey ruleKeyObj = RuleKey.of(repoKey, ruleKey);
            Preconditions.checkArgument(!this.newActiveRules.containsKey(ruleKeyObj), "The rule '%s' is already activated", ruleKeyObj);
            NewBuiltInActiveRule newActiveRule = new NewBuiltInActiveRule(repoKey, ruleKey);
            this.newActiveRules.put(ruleKeyObj, newActiveRule);
            return newActiveRule;
        }

        @Override
        public String language() {
            return this.language;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean isDefault() {
            return this.isDefault;
        }

        @Override
        public Collection<NewBuiltInActiveRule> activeRules() {
            return this.newActiveRules.values();
        }

        @Override
        public void done() {
            Preconditions.checkArgument(StringUtils.isNotBlank(this.name), "Built-In Quality Profile can't have a blank name");
            Preconditions.checkArgument(StringUtils.isNotBlank(this.language), "Built-In Quality Profile can't have a blank language");
            this.context.registerProfile(this);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("NewBuiltInQualityProfile{");
            sb.append("name='").append(this.name).append('\'');
            sb.append(", language='").append(this.language).append('\'');
            sb.append(", default='").append(this.isDefault).append('\'');
            sb.append('}');
            return sb.toString();
        }
    }

    public static interface NewBuiltInQualityProfile {
        public NewBuiltInQualityProfile setDefault(boolean var1);

        public NewBuiltInActiveRule activateRule(String var1, String var2);

        public Collection<NewBuiltInActiveRule> activeRules();

        public String language();

        public String name();

        public boolean isDefault();

        public void done();
    }

    public static class Context {
        private final Map<String, Map<String, BuiltInQualityProfile>> profilesByLanguageAndName = new HashMap<String, Map<String, BuiltInQualityProfile>>();

        public NewBuiltInQualityProfile createBuiltInQualityProfile(String name, String language) {
            return new NewBuiltInQualityProfileImpl(this, name, language);
        }

        private void registerProfile(NewBuiltInQualityProfileImpl newProfile) {
            String language = newProfile.language();
            String name = newProfile.name();
            Preconditions.checkArgument(!this.profilesByLanguageAndName.computeIfAbsent(language, l -> new LinkedHashMap()).containsKey(name), "There is already a quality profile with name '%s' for language '%s'", name, language);
            this.profilesByLanguageAndName.get(language).put(name, new BuiltInQualityProfileImpl(newProfile));
        }

        public Map<String, Map<String, BuiltInQualityProfile>> profilesByLanguageAndName() {
            return this.profilesByLanguageAndName;
        }

        public BuiltInQualityProfile profile(String language, String name) {
            return (BuiltInQualityProfile)this.profilesByLanguageAndName.computeIfAbsent(language, l -> new LinkedHashMap()).get(name);
        }
    }
}

