/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.cache.CpdSerializationInput;
import org.sonar.php.cache.SerializationResult;
import org.sonar.php.cache.StringTable;
import org.sonar.php.cache.VarLengthOutputStream;
import org.sonar.php.metrics.CpdVisitor;

public class CpdSerializer {
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private final VarLengthOutputStream out = new VarLengthOutputStream(this.stream);
    private final StringTable stringTable = new StringTable();

    private CpdSerializer() {
    }

    public static SerializationResult toBinary(CpdSerializationInput serializationInput) {
        CpdSerializer serializer = new CpdSerializer();
        return serializer.convert(serializationInput);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private SerializationResult convert(CpdSerializationInput serializationInput) {
        try (VarLengthOutputStream varLengthOutputStream = this.out;){
            SerializationResult serializationResult;
            block15: {
                ByteArrayOutputStream byteArrayOutputStream = this.stream;
                try {
                    String pluginVersion = serializationInput.pluginVersion();
                    this.writeText(pluginVersion);
                    List<CpdVisitor.CpdToken> cpdTokens = serializationInput.cpdTokens();
                    this.writeInt(cpdTokens.size());
                    for (CpdVisitor.CpdToken cpdToken : cpdTokens) {
                        this.write(cpdToken);
                    }
                    this.out.writeUTF("END");
                    serializationResult = new SerializationResult(this.stream.toByteArray(), this.writeStringTable());
                    if (byteArrayOutputStream == null) break block15;
                }
                catch (Throwable throwable) {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                byteArrayOutputStream.close();
            }
            return serializationResult;
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't store data in cache", e);
        }
    }

    private void write(CpdVisitor.CpdToken cpdToken) throws IOException {
        this.writeInt(cpdToken.line());
        this.writeInt(cpdToken.column());
        this.writeInt(cpdToken.endLine());
        this.writeInt(cpdToken.endColumn());
        this.writeText(cpdToken.text());
    }

    private void writeText(@Nullable String text) throws IOException {
        this.out.writeInt(this.stringTable.getIndex(text));
    }

    private void writeInt(int number) throws IOException {
        this.out.writeInt(number);
    }

    private byte[] writeStringTable() throws IOException {
        ByteArrayOutputStream stringTableStream = new ByteArrayOutputStream();
        VarLengthOutputStream output = new VarLengthOutputStream(stringTableStream);
        List<String> byIndex = this.stringTable.getStringList();
        output.writeInt(byIndex.size());
        for (String string : byIndex) {
            output.writeUTF(string);
        }
        output.writeUTF("END");
        return stringTableStream.toByteArray();
    }
}

