/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.AbstractDuplicateBranchImplementationCheck;
import org.sonar.php.checks.utils.SyntacticEquivalence;
import org.sonar.plugins.php.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.StatementTree;

@Rule(key="S3923")
public class AllBranchesIdenticalCheck
extends AbstractDuplicateBranchImplementationCheck {
    private static final String MESSAGE = "Remove this conditional structure or edit its code blocks so that they're not all the same.";

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        if (SyntacticEquivalence.areSyntacticallyEquivalent(tree.trueExpression(), tree.falseExpression())) {
            this.context().newIssue(this, tree.condition(), tree.queryToken(), MESSAGE);
        }
        super.visitConditionalExpression(tree);
    }

    @Override
    protected void reportAllDuplicateBranches(SyntaxToken keyword) {
        this.context().newIssue(this, keyword, MESSAGE);
    }

    @Override
    protected void reportTwoDuplicateBranches(String branchType, List<StatementTree> originalBranch, List<StatementTree> duplicateBranch) {
    }
}

