/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.tree.impl.expression.AssignmentByReferenceTreeImpl;
import org.sonar.php.tree.impl.expression.AssignmentExpressionTreeImpl;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1121")
public class AssignmentInSubExpressionCheck
extends PHPVisitorCheck {
    private static final Tree.Kind[] ALLOWED_PARENTS = new Tree.Kind[]{Tree.Kind.IF_STATEMENT, Tree.Kind.ELSEIF_CLAUSE, Tree.Kind.CALL_ARGUMENT, Tree.Kind.EXPRESSION_STATEMENT, Tree.Kind.ASSIGNMENT_BY_REFERENCE, Tree.Kind.ASSIGNMENT, Tree.Kind.ALTERNATIVE_CONDITIONAL_OR};

    @Override
    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        Tree parent = AssignmentInSubExpressionCheck.getParent(tree);
        if (!parent.is(ALLOWED_PARENTS)) {
            SyntaxToken toReport = AssignmentInSubExpressionCheck.getToken(tree);
            this.context().newIssue(this, toReport, String.format("Extract the assignment of \"%s\" from this expression.", tree.variable().toString()));
        }
        super.visitAssignmentExpression(tree);
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.scan(tree.condition());
        this.scan(tree.statements());
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.scan(tree.statements());
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.scan(tree.statement());
    }

    private static SyntaxToken getToken(AssignmentExpressionTree tree) {
        if (tree.is(Tree.Kind.ASSIGNMENT_BY_REFERENCE)) {
            return ((AssignmentByReferenceTreeImpl)tree).equalToken();
        }
        return ((AssignmentExpressionTreeImpl)tree).equalToken();
    }

    private static Tree getParent(AssignmentExpressionTree tree) {
        Tree result = tree.getParent();
        while (result.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            result = result.getParent();
        }
        return result;
    }
}

