/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.SyntacticEquivalence;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.ThrowStatementTree;
import org.sonar.plugins.php.api.tree.statement.TryStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S2737")
public class CatchRethrowingCheck
extends PHPVisitorCheck {
    public static final String KEY = "S2737";

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        List<CatchBlockTree> catchBlocks = tree.catchBlocks();
        if (catchBlocks.stream().allMatch(catchBlock -> CatchRethrowingCheck.hasSingleStatement(catchBlock) && CatchRethrowingCheck.isRetrowingException(catchBlock))) {
            catchBlocks.stream().flatMap(catchBlock -> catchBlock.block().statements().stream()).forEach(statement -> this.context().newIssue(this, (Tree)statement, "Add logic to this catch clause or eliminate it and rethrow the exception automatically."));
        }
        super.visitTryStatement(tree);
    }

    private static boolean hasSingleStatement(CatchBlockTree catchBlock) {
        return catchBlock.block().statements().size() == 1;
    }

    private static boolean isRetrowingException(CatchBlockTree catchBlock) {
        StatementTree statement = catchBlock.block().statements().get(0);
        if (!statement.is(Tree.Kind.THROW_STATEMENT) || catchBlock.variable() == null) {
            return false;
        }
        ExpressionTree thrownExpression = CheckUtils.skipParenthesis(((ThrowStatementTree)statement).expression());
        return SyntacticEquivalence.areSyntacticallyEquivalent(catchBlock.variable(), thrownExpression);
    }
}

