/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.Symbols;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S5708")
public class CatchThrowableCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Change this type to be a class deriving from \"Throwable\".";
    private static final String SECONDARY_MESSAGE = "Class definition.";
    private static final QualifiedName THROWABLE_FQN = QualifiedName.qualifiedName("Throwable");

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        tree.exceptionTypes().stream().filter(type -> !Symbols.getClass(type).is(ClassSymbol.Kind.INTERFACE)).filter(type -> Symbols.getClass(type).isSubTypeOf(THROWABLE_FQN).isFalse()).forEach(this::addIssue);
        super.visitCatchBlock(tree);
    }

    private void addIssue(NamespaceNameTree tree) {
        this.context().newIssue(this, tree, MESSAGE).secondary(Symbols.getClass(tree).location(), SECONDARY_MESSAGE);
    }
}

