/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.List;
import org.sonar.check.Rule;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S3973")
public class ConditionalIndentationCheck
extends PHPVisitorCheck {
    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.checkIndentation(tree.ifToken(), tree.statements());
        super.visitIfStatement(tree);
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.checkIndentation(tree.whileToken(), tree.statements());
        super.visitWhileStatement(tree);
    }

    @Override
    public void visitElseifClause(ElseifClauseTree tree) {
        this.checkIndentation(tree.elseifToken(), tree.statements());
        super.visitElseifClause(tree);
    }

    @Override
    public void visitElseClause(ElseClauseTree tree) {
        this.checkIndentation(tree.elseToken(), tree.statements());
        super.visitElseClause(tree);
    }

    @Override
    public void visitForEachStatement(ForEachStatementTree tree) {
        this.checkIndentation(tree.foreachToken(), tree.statements());
        super.visitForEachStatement(tree);
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.checkIndentation(tree.forToken(), tree.statements());
        super.visitForStatement(tree);
    }

    private void checkIndentation(SyntaxToken conditionalFirstToken, List<StatementTree> statements) {
        if (statements.isEmpty() || statements.size() == 1 && statements.get(0).is(Tree.Kind.BLOCK)) {
            return;
        }
        StatementTree firstStatement = statements.get(0);
        SyntaxToken firstStatementToken = ((PHPTree)((Object)firstStatement)).getFirstToken();
        if (conditionalFirstToken.column() == firstStatementToken.column()) {
            String message = "Use curly braces or indentation to denote the code conditionally executed by this \"" + conditionalFirstToken.text() + "\".";
            this.context().newIssue(this, conditionalFirstToken, message).secondary(firstStatementToken, null);
        }
    }
}

