/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.BinaryExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ConditionalExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.expression.UnaryExpressionTree;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.ElseifClauseTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S5797")
public class ConstantConditionCheck
extends PHPVisitorCheck {
    public static final String KEY = "S5797";
    private static final String MESSAGE = "Replace this expression; used as a condition it will always be constant.";
    private static final Tree.Kind[] BOOLEAN_CONSTANT_KINDS = new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.REGULAR_STRING_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.HEREDOC_LITERAL, Tree.Kind.NOWDOC_LITERAL, Tree.Kind.MAGIC_CONSTANT, Tree.Kind.ARRAY_INITIALIZER_FUNCTION, Tree.Kind.ARRAY_INITIALIZER_BRACKET, Tree.Kind.NEW_EXPRESSION, Tree.Kind.FUNCTION_EXPRESSION};
    private static final Tree.Kind[] LITERAL_KINDS = new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.REGULAR_STRING_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.HEREDOC_LITERAL, Tree.Kind.NOWDOC_LITERAL, Tree.Kind.MAGIC_CONSTANT};
    private static final Tree.Kind[] CONDITIONAL_KINDS = new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND, Tree.Kind.CONDITIONAL_OR, Tree.Kind.ALTERNATIVE_CONDITIONAL_AND, Tree.Kind.ALTERNATIVE_CONDITIONAL_OR, Tree.Kind.ALTERNATIVE_CONDITIONAL_XOR};

    private static boolean isBooleanConstant(ExpressionTree conditionExpression) {
        if (conditionExpression.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            ParenthesisedExpressionTree parenthesisedExpression = (ParenthesisedExpressionTree)conditionExpression;
            return ConstantConditionCheck.isBooleanConstant(parenthesisedExpression.expression());
        }
        if (conditionExpression instanceof BinaryExpressionTree) {
            BinaryExpressionTree binaryExpression = (BinaryExpressionTree)conditionExpression;
            return ConstantConditionCheck.isValueConstant(binaryExpression.leftOperand()) && ConstantConditionCheck.isValueConstant(binaryExpression.rightOperand());
        }
        return conditionExpression.is(BOOLEAN_CONSTANT_KINDS);
    }

    private static boolean isValueConstant(ExpressionTree conditionExpression) {
        if (conditionExpression.is(Tree.Kind.PARENTHESISED_EXPRESSION)) {
            ParenthesisedExpressionTree parenthesisedExpression = (ParenthesisedExpressionTree)conditionExpression;
            return ConstantConditionCheck.isValueConstant(parenthesisedExpression.expression());
        }
        if (conditionExpression instanceof BinaryExpressionTree) {
            BinaryExpressionTree binaryExpression = (BinaryExpressionTree)conditionExpression;
            return ConstantConditionCheck.isValueConstant(binaryExpression.leftOperand()) && ConstantConditionCheck.isValueConstant(binaryExpression.rightOperand());
        }
        return conditionExpression.is(LITERAL_KINDS);
    }

    private static boolean containsClassOrInterfaceDeclaration(IfStatementTree ifStatement) {
        return ifStatement.statements().stream().filter(s -> s.is(Tree.Kind.BLOCK)).map(BlockTree.class::cast).flatMap(block -> block.statements().stream()).anyMatch(ConstantConditionCheck::isClassOrInterfaceDeclaration);
    }

    private static boolean isClassOrInterfaceDeclaration(StatementTree statement) {
        return statement.is(Tree.Kind.CLASS_DECLARATION, Tree.Kind.INTERFACE_DECLARATION);
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        if (!ConstantConditionCheck.containsClassOrInterfaceDeclaration(tree)) {
            ExpressionTree conditionExpression = tree.condition().expression();
            this.checkBooleanConstant(conditionExpression);
        }
        super.visitIfStatement(tree);
    }

    @Override
    public void visitElseifClause(ElseifClauseTree tree) {
        ExpressionTree conditionExpression = tree.condition().expression();
        this.checkBooleanConstant(conditionExpression);
        super.visitElseifClause(tree);
    }

    @Override
    public void visitBinaryExpression(BinaryExpressionTree tree) {
        if (tree.is(CONDITIONAL_KINDS) && !ConstantConditionCheck.isBooleanConstant(tree)) {
            this.checkBooleanConstant(tree.leftOperand());
            this.checkBooleanConstant(tree.rightOperand());
        }
        super.visitBinaryExpression(tree);
    }

    @Override
    public void visitPrefixExpression(UnaryExpressionTree tree) {
        if (tree.is(Tree.Kind.LOGICAL_COMPLEMENT)) {
            this.checkBooleanConstant(tree.expression());
        }
        super.visitPrefixExpression(tree);
    }

    @Override
    public void visitConditionalExpression(ConditionalExpressionTree tree) {
        ExpressionTree conditionExpression = tree.condition();
        this.checkBooleanConstant(conditionExpression);
        super.visitConditionalExpression(tree);
    }

    private void checkBooleanConstant(ExpressionTree conditionExpression) {
        if (ConstantConditionCheck.isBooleanConstant(conditionExpression)) {
            this.newIssue(conditionExpression, MESSAGE);
        }
    }
}

