/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.FunctionUsageCheck;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S2041")
public class EchoWithParenthesisCheck
extends FunctionUsageCheck {
    public static final String KEY = "S2041";
    private static final String MESSAGE = "Remove the parentheses from this \"echo\" call.";

    @Override
    protected Set<String> lookedUpFunctionNames() {
        return Set.of("echo");
    }

    @Override
    protected void checkFunctionCall(FunctionCallTree tree) {
        if (EchoWithParenthesisCheck.isParenthesized(tree)) {
            this.newIssue(tree.callee(), MESSAGE);
        }
    }

    private static boolean isParenthesized(FunctionCallTree tree) {
        return tree.callArguments().size() == 1 && ((CallArgumentTree)tree.callArguments().get(0)).value().is(Tree.Kind.PARENTHESISED_EXPRESSION);
    }
}

