/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S103")
public class LineLengthCheck
extends PHPVisitorCheck {
    public static final String KEY = "S103";
    private static final String MESSAGE = "Split this %s characters long line (which is greater than %s authorized).";
    public static final int DEFAULT = 120;
    @RuleProperty(key="maximumLineLength", defaultValue="120")
    public int maximumLineLength = 120;

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        Stream<String> lines = CheckUtils.lines(this.context().getPhpFile());
        int[] idx = new int[]{0};
        lines.forEach(line -> {
            if (line.length() > this.maximumLineLength) {
                String message = String.format(MESSAGE, line.length(), this.maximumLineLength);
                this.context().newLineIssue(this, idx[0] + 1, message);
            }
            idx[0] = idx[0] + 1;
        });
    }
}

