/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.statement.DoWhileStatementTree;
import org.sonar.plugins.php.api.tree.statement.ElseClauseTree;
import org.sonar.plugins.php.api.tree.statement.ForEachStatementTree;
import org.sonar.plugins.php.api.tree.statement.ForStatementTree;
import org.sonar.plugins.php.api.tree.statement.IfStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.SwitchStatementTree;
import org.sonar.plugins.php.api.tree.statement.TryStatementTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;
import org.sonar.plugins.php.api.visitors.PreciseIssue;

@Rule(key="S134")
public class NestedControlFlowDepthCheck
extends PHPVisitorCheck {
    public static final String KEY = "S134";
    private static final String MESSAGE = "Refactor this code to not nest more than %s \"if\", \"for\", \"while\", \"switch\" and \"try\" statements.";
    private Deque<Tree> nestingStack = new ArrayDeque<Tree>();
    public static final int DEFAULT = 4;
    @RuleProperty(key="max", defaultValue="4")
    public int max = 4;

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        this.nestingStack.clear();
        super.visitCompilationUnit(tree);
    }

    @Override
    public void visitIfStatement(IfStatementTree tree) {
        this.enterBlock(tree.ifToken());
        this.scanIf(tree);
        this.leaveBlock();
    }

    private void scanIf(IfStatementTree ifTree) {
        this.scan(ifTree.statements());
        this.scan(ifTree.elseifClauses());
        ElseClauseTree elseClause = ifTree.elseClause();
        if (elseClause != null) {
            List<StatementTree> elseStatements = elseClause.statements();
            if (elseStatements.size() == 1 && elseStatements.get(0).is(Tree.Kind.IF_STATEMENT)) {
                this.scanIf((IfStatementTree)elseStatements.get(0));
            } else {
                this.scan(elseClause);
            }
        }
    }

    @Override
    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.enterBlock(tree.doToken());
        super.visitDoWhileStatement(tree);
        this.leaveBlock();
    }

    @Override
    public void visitForStatement(ForStatementTree tree) {
        this.enterBlock(tree.forToken());
        super.visitForStatement(tree);
        this.leaveBlock();
    }

    @Override
    public void visitForEachStatement(ForEachStatementTree tree) {
        this.enterBlock(tree.foreachToken());
        super.visitForEachStatement(tree);
        this.leaveBlock();
    }

    @Override
    public void visitSwitchStatement(SwitchStatementTree tree) {
        this.enterBlock(tree.switchToken());
        super.visitSwitchStatement(tree);
        this.leaveBlock();
    }

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        this.enterBlock(tree.tryToken());
        super.visitTryStatement(tree);
        this.leaveBlock();
    }

    @Override
    public void visitWhileStatement(WhileStatementTree tree) {
        this.enterBlock(tree.whileToken());
        super.visitWhileStatement(tree);
        this.leaveBlock();
    }

    private void enterBlock(Tree tree) {
        this.nestingStack.push(tree);
        if (this.nestingStack.size() == this.max + 1) {
            PreciseIssue issue = this.context().newIssue(this, tree, String.format(MESSAGE, this.max));
            this.nestingStack.forEach(secondaryTree -> issue.secondary((Tree)secondaryTree, "Nesting +1"));
        }
    }

    private void leaveBlock() {
        this.nestingStack.pop();
    }
}

