/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.symbols.SymbolTable;
import org.sonar.plugins.php.api.tree.ScriptTree;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.AssignmentExpressionTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;
import org.sonar.plugins.php.api.tree.statement.BlockTree;
import org.sonar.plugins.php.api.tree.statement.ExpressionStatementTree;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.visitors.PHPSubscriptionCheck;
import org.sonar.plugins.php.api.visitors.PHPTreeSubscriber;

@Rule(key="S4143")
public class OverwrittenArrayElementCheck
extends PHPSubscriptionCheck {
    private static final String MESSAGE = "Verify this is the array key that was intended to be written to; a value has already been saved for it and not used.";
    private static final String MESSAGE_SECONDARY = "Original assignment.";
    private Map<String, Symbol> namesToSymbols = new HashMap<String, Symbol>();
    private Map<String, Map<String, AssignmentExpressionTree>> writtenAndUnread = new HashMap<String, Map<String, AssignmentExpressionTree>>();

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return Arrays.asList(Tree.Kind.BLOCK, Tree.Kind.SCRIPT);
    }

    @Override
    public void visitNode(Tree tree) {
        this.namesToSymbols.clear();
        this.writtenAndUnread.clear();
        List<StatementTree> statementTrees = tree.is(Tree.Kind.BLOCK) ? ((BlockTree)tree).statements() : ((ScriptTree)tree).statements();
        for (StatementTree statementTree : statementTrees) {
            if (!OverwrittenArrayElementCheck.isArrayKeyAssignmentStatement(statementTree)) {
                this.removeReadArrayKeys(statementTree);
                continue;
            }
            AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)((ExpressionStatementTree)statementTree).expression();
            ArrayAccessTree arrayAccessTree = (ArrayAccessTree)assignmentExpressionTree.variable();
            String key = ((LiteralTree)arrayAccessTree.offset()).value();
            String variableName = ((VariableIdentifierTree)arrayAccessTree.object()).text();
            Symbol variableSymbol = this.context().symbolTable().getSymbol(arrayAccessTree.object());
            this.checkArrayKeyWrite(statementTree, assignmentExpressionTree, key, variableName, variableSymbol);
            this.updateWrittenAndUnread(assignmentExpressionTree, key, variableName, variableSymbol);
        }
        super.visitNode(tree);
    }

    private void checkArrayKeyWrite(StatementTree statementTree, AssignmentExpressionTree assignmentExpressionTree, String key, String variableName, Symbol variableSymbol) {
        if (this.writtenAndUnread.containsKey(variableName) && this.writtenAndUnread.get(variableName).containsKey(key) && !this.symbolWasUsedInTree(variableSymbol, assignmentExpressionTree.value())) {
            AssignmentExpressionTree firstAssignmentTree = this.writtenAndUnread.get(variableName).get(key);
            this.context().newIssue(this, statementTree, MESSAGE).secondary(firstAssignmentTree, MESSAGE_SECONDARY);
        }
    }

    private void updateWrittenAndUnread(AssignmentExpressionTree statementTree, String key, String variableName, Symbol variableSymbol) {
        this.writtenAndUnread.computeIfAbsent(variableName, k -> new HashMap()).put(key, statementTree);
        this.namesToSymbols.put(variableName, variableSymbol);
    }

    private void removeReadArrayKeys(StatementTree statementTree) {
        this.writtenAndUnread = this.writtenAndUnread.entrySet().stream().filter(entry -> !this.symbolWasUsedInTree(this.namesToSymbols.get(entry.getKey()), statementTree)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static boolean isArrayKeyAssignmentStatement(StatementTree tree) {
        if (!tree.is(Tree.Kind.EXPRESSION_STATEMENT)) {
            return false;
        }
        if (!((ExpressionStatementTree)tree).expression().is(Tree.Kind.ASSIGNMENT)) {
            return false;
        }
        AssignmentExpressionTree assignmentExpressionTree = (AssignmentExpressionTree)((ExpressionStatementTree)tree).expression();
        if (!assignmentExpressionTree.variable().is(Tree.Kind.ARRAY_ACCESS) || !((ArrayAccessTree)assignmentExpressionTree.variable()).object().is(Tree.Kind.VARIABLE_IDENTIFIER)) {
            return false;
        }
        ArrayAccessTree arrayAccessTree = (ArrayAccessTree)assignmentExpressionTree.variable();
        String arrayName = ((VariableIdentifierTree)arrayAccessTree.object()).text();
        return !CheckUtils.SUPERGLOBALS.contains(arrayName) && ((ArrayAccessTree)assignmentExpressionTree.variable()).offset() != null && ((ArrayAccessTree)assignmentExpressionTree.variable()).offset().is(Tree.Kind.NUMERIC_LITERAL, Tree.Kind.REGULAR_STRING_LITERAL);
    }

    private boolean symbolWasUsedInTree(Symbol symbol, Tree tree) {
        SymbolUsageVisitor checkVisitor = new SymbolUsageVisitor(symbol, this.context().symbolTable());
        checkVisitor.scanTree(tree);
        return checkVisitor.foundUsage || checkVisitor.foundFlowBreakingStatement;
    }

    private static class SymbolUsageVisitor
    extends PHPTreeSubscriber {
        private final Symbol symbol;
        private final SymbolTable symbolTable;
        private boolean foundUsage = false;
        private boolean foundFlowBreakingStatement = false;

        public SymbolUsageVisitor(Symbol symbol, SymbolTable symbolTable) {
            this.symbol = symbol;
            this.symbolTable = symbolTable;
        }

        @Override
        public List<Tree.Kind> nodesToVisit() {
            return Arrays.asList(Tree.Kind.VARIABLE_IDENTIFIER, Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.BREAK_STATEMENT, Tree.Kind.THROW_STATEMENT);
        }

        @Override
        public void visitNode(Tree tree) {
            if (tree.is(Tree.Kind.CONTINUE_STATEMENT, Tree.Kind.RETURN_STATEMENT, Tree.Kind.BREAK_STATEMENT, Tree.Kind.THROW_STATEMENT)) {
                this.foundFlowBreakingStatement = true;
                return;
            }
            Symbol currentSymbol = this.symbolTable.getSymbol(tree);
            if (!this.foundUsage) {
                this.foundUsage = currentSymbol == this.symbol;
            }
        }
    }
}

