/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.FunctionUsageCheck;
import org.sonar.php.ini.BasePhpIniIssue;
import org.sonar.php.ini.PhpIniCheck;
import org.sonar.php.ini.PhpIniIssue;
import org.sonar.php.ini.tree.Directive;
import org.sonar.php.ini.tree.PhpIniFile;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;

@Rule(key="S3332")
public class SessionCookiePersistenceCheck
extends FunctionUsageCheck
implements PhpIniCheck {
    private static final String PHP_INI_MESSAGE = "Configure \"session.cookie_lifetime\" to 0.";
    private static final String PHP_CODE_MESSAGE = "Set \"lifetime\" parameter to \"0\".";

    @Override
    public List<PhpIniIssue> analyze(PhpIniFile phpIniFile) {
        ArrayList<PhpIniIssue> issues = new ArrayList<PhpIniIssue>();
        for (Directive directive : phpIniFile.directivesForName("session.cookie_lifetime")) {
            String value = directive.value().text();
            if ("0".equals(value) || "\"0\"".equals(value)) continue;
            issues.add(BasePhpIniIssue.newIssue(PHP_INI_MESSAGE).line(directive.name().line()));
        }
        return issues;
    }

    @Override
    protected Set<String> lookedUpFunctionNames() {
        return Set.of("session_set_cookie_params");
    }

    @Override
    protected void checkFunctionCall(FunctionCallTree functionCall) {
        LiteralTree literal;
        ExpressionTree lifetimeArgumentValue;
        Optional<CallArgumentTree> lifetimeArgument = CheckUtils.argument(functionCall, "lifetime", 0);
        if (lifetimeArgument.isPresent() && (lifetimeArgumentValue = lifetimeArgument.get().value()).is(Tree.Kind.NUMERIC_LITERAL) && !"0".equals((literal = (LiteralTree)lifetimeArgumentValue).value())) {
            this.context().newIssue(this, lifetimeArgumentValue, PHP_CODE_MESSAGE);
        }
    }
}

