/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.symbols.LocationInFileImpl;
import org.sonar.plugins.php.api.tree.CompilationUnitTree;
import org.sonar.plugins.php.api.visitors.IssueLocation;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1131")
public class TrailingWhitespaceCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Remove the useless trailing whitespaces at the end of this line.";
    private static final Pattern WHITESPACE_PATTERN = Pattern.compile("[^\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]+([\\t\\u000B\\f\\u0020\\u00A0\\uFEFF\\p{Zs}]+)$");

    @Override
    public void visitCompilationUnit(CompilationUnitTree tree) {
        Stream<String> lines = CheckUtils.lines(this.context().getPhpFile());
        Iterator it = lines.iterator();
        int lineNumber = 1;
        while (it.hasNext()) {
            this.checkLine((String)it.next(), lineNumber);
            ++lineNumber;
        }
    }

    private void checkLine(String line, int lineNumber) {
        Matcher m;
        if (TrailingWhitespaceCheck.shouldCheckLine(line) && (m = WHITESPACE_PATTERN.matcher(line)).find()) {
            this.context().newIssue(this, TrailingWhitespaceCheck.issueLocation(m, lineNumber));
        }
    }

    private static boolean shouldCheckLine(String line) {
        if (line.isEmpty()) {
            return false;
        }
        char lastCharacter = line.charAt(line.length() - 1);
        return lastCharacter != ';' && lastCharacter != '{' && lastCharacter != '}';
    }

    private static IssueLocation issueLocation(Matcher m, int lineNumber) {
        LocationInFileImpl location = new LocationInFileImpl(null, lineNumber, m.start(1), lineNumber, m.end(1));
        return new IssueLocation(location, MESSAGE);
    }
}

