/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import org.sonar.check.Rule;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.Symbols;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.tree.statement.NamespaceStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S5911")
public class UncatchableExceptionCheck
extends PHPVisitorCheck {
    public static final String KEY = "S5911";
    private static final String MESSAGE = "Create class \"%s\" in namespace or check correct import of class";
    private static final String GLOBAL_NAMESPACE = "";
    private String currentNamespace = "";

    @Override
    public void visitNamespaceStatement(NamespaceStatementTree tree) {
        this.currentNamespace = tree.namespaceName() != null ? tree.namespaceName().qualifiedName().toLowerCase() : GLOBAL_NAMESPACE;
        super.visitNamespaceStatement(tree);
        if (this.isBracketedNamespace(tree)) {
            this.currentNamespace = GLOBAL_NAMESPACE;
        }
    }

    private boolean isBracketedNamespace(NamespaceStatementTree tree) {
        return tree.openCurlyBrace() != null;
    }

    @Override
    public void visitCatchBlock(CatchBlockTree tree) {
        if (!this.currentNamespace.isEmpty()) {
            tree.exceptionTypes().stream().filter(this::isMissingException).forEach(this::raiseIssue);
        }
        super.visitCatchBlock(tree);
    }

    private void raiseIssue(NamespaceNameTree tree) {
        this.context().newIssue(this, tree, String.format(MESSAGE, tree.fullyQualifiedName()));
    }

    private boolean isMissingException(NamespaceNameTree tree) {
        ClassSymbol symbol = Symbols.getClass(tree);
        return symbol.isUnknownSymbol() && symbol.qualifiedName().toString().startsWith(this.currentNamespace);
    }
}

