/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.sonar.check.Rule;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.Symbols;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.statement.CatchBlockTree;
import org.sonar.plugins.php.api.tree.statement.TryStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1045")
public class UnreachableCatchBlockCheck
extends PHPVisitorCheck {
    private static final String MESSAGE = "Catch this exception only once; it is already handled by a previous catch clause.";
    private static final String PARENT_MESSAGE = "A parent exception class is caught here.";
    private static final String SAME_MESSAGE = "The same exception class is caught here.";
    private static final BinaryOperator<NamespaceNameTree> DUPLICATE_RESOLUTION = (a, b) -> a;

    @Override
    public void visitTryStatement(TryStatementTree tree) {
        HashMap<ClassSymbol, NamespaceNameTree> previouslyCaught = new HashMap<ClassSymbol, NamespaceNameTree>();
        for (CatchBlockTree catchBlock : tree.catchBlocks()) {
            Map<ClassSymbol, NamespaceNameTree> caughtInThisCatch = catchBlock.exceptionTypes().stream().collect(Collectors.toMap(Symbols::getClass, e -> e, DUPLICATE_RESOLUTION));
            Map<ClassSymbol, Optional> caughtSuperClasses = caughtInThisCatch.keySet().stream().collect(Collectors.toMap(e -> e, e -> previouslyCaught.keySet().stream().filter(s -> e.isSubTypeOf(s.qualifiedName()).isTrue()).findFirst()));
            if (caughtSuperClasses.values().stream().allMatch(Optional::isPresent)) {
                caughtInThisCatch.forEach((symbol, name) -> {
                    ClassSymbol superClass = (ClassSymbol)((Optional)caughtSuperClasses.get(symbol)).get();
                    NamespaceNameTree redundantCatch = (NamespaceNameTree)previouslyCaught.get(superClass);
                    String secondaryMessage = redundantCatch.qualifiedName().equalsIgnoreCase(symbol.qualifiedName().simpleName()) ? SAME_MESSAGE : PARENT_MESSAGE;
                    this.context().newIssue(this, (Tree)name, MESSAGE).secondary((Tree)previouslyCaught.get(superClass), secondaryMessage);
                });
            }
            previouslyCaught.putAll(caughtInThisCatch);
        }
        super.visitTryStatement(tree);
    }
}

