/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.Symbols;
import org.sonar.php.tree.TreeUtils;
import org.sonar.php.tree.impl.VariableIdentifierTreeImpl;
import org.sonar.php.tree.symbols.SymbolImpl;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.ClassDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.NamespaceNameTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.declaration.TypeNameTree;
import org.sonar.plugins.php.api.tree.declaration.TypeTree;
import org.sonar.plugins.php.api.tree.expression.ArrayInitializerTree;
import org.sonar.plugins.php.api.tree.expression.ArrayPairTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.NewExpressionTree;
import org.sonar.plugins.php.api.tree.statement.ReturnStatementTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S5693")
public class RequestContentLengthCheck
extends PHPVisitorCheck {
    public static final int DEFAULT = 8000000;
    @RuleProperty(key="fileUploadSizeLimit", defaultValue="8000000")
    long fileUploadSizeLimit = 8000000L;
    private static final QualifiedName SYMFONY_FILE_CONSTRAINT = QualifiedName.qualifiedName("Symfony\\Component\\Validator\\Constraints\\File");
    private static final Pattern SIZE_FORMAT = Pattern.compile("^(?<number>[0-9]+)(?<unit>k|M|Ki|Mi)?$");
    private static final Pattern LARAVEL_SIZE_FORMAT = Pattern.compile("^max:(?<size>[0-9]+)$");
    private static final Tree.Kind[] ARRAY = new Tree.Kind[]{Tree.Kind.ARRAY_INITIALIZER_BRACKET, Tree.Kind.ARRAY_INITIALIZER_FUNCTION};
    private static final QualifiedName LARAVEL_FORM_REQUEST = QualifiedName.qualifiedName("Illuminate\\Foundation\\Http\\FormRequest");
    private static final QualifiedName LARAVEL_CONTROLLER = QualifiedName.qualifiedName("App\\Http\\Controllers\\Controller");
    private static final String LARAVEL_RULES_KEY = "rules";
    private static final Map<String, Integer> LARAVEL_RULES_ARGUMENT = new HashMap<String, Integer>();
    private static final String MESSAGE = "Make sure the content length limit is safe here.";

    @Override
    public void visitNewExpression(NewExpressionTree tree) {
        if (this.isInstantiationOf(tree, SYMFONY_FILE_CONSTRAINT) && ((FunctionCallTree)tree.expression()).callArguments().size() == 1) {
            this.checkSymfonyFileConstraint(((CallArgumentTree)((FunctionCallTree)tree.expression()).callArguments().get(0)).value());
        }
        super.visitNewExpression(tree);
    }

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        String fullFunctionName;
        super.visitFunctionCall(tree);
        String string = fullFunctionName = tree.callee().is(Tree.Kind.NAMESPACE_NAME) ? CheckUtils.getLowerCaseFunctionName(tree) : this.getMethodName(tree);
        if (fullFunctionName == null) {
            return;
        }
        RequestContentLengthCheck.getLaravelValidationsArgument(tree, fullFunctionName).map(CallArgumentTree::value).ifPresent(this::checkLaravelFileRules);
    }

    @Override
    public void visitMethodDeclaration(MethodDeclarationTree tree) {
        super.visitMethodDeclaration(tree);
        if (CheckUtils.isMethodInheritedFromClassOrInterface(LARAVEL_FORM_REQUEST, tree) && LARAVEL_RULES_KEY.equalsIgnoreCase(tree.name().text())) {
            this.checkLaravelFormRequestRulesReturns(tree);
        }
    }

    private void checkLaravelFormRequestRulesReturns(MethodDeclarationTree tree) {
        TreeUtils.descendants(tree, ReturnStatementTree.class).map(ReturnStatementTree::expression).filter(Objects::nonNull).map(CheckUtils::assignedValue).forEach(this::checkLaravelFileRules);
    }

    private void checkLaravelFileRules(ExpressionTree tree) {
        if (!tree.is(ARRAY)) {
            return;
        }
        RequestContentLengthCheck.getLaravelFileValidations((ArrayInitializerTree)tree).filter(v -> v.isMaxHigher(this.fileUploadSizeLimit)).forEach(v -> this.context().newIssue(this, v.definition, MESSAGE));
    }

    private String getMethodName(FunctionCallTree tree) {
        ExpressionTree expressionTree;
        ExpressionTree callee = tree.callee();
        String className = null;
        if (callee.is(Tree.Kind.CLASS_MEMBER_ACCESS) && ((MemberAccessTree)callee).object().is(Tree.Kind.NAMESPACE_NAME)) {
            className = this.getFullyQualifiedName((NamespaceNameTree)((MemberAccessTree)callee).object()).toString();
        } else if (callee.is(Tree.Kind.OBJECT_MEMBER_ACCESS) && (expressionTree = ((MemberAccessTree)callee).object()) instanceof VariableIdentifierTreeImpl) {
            VariableIdentifierTreeImpl receiver = (VariableIdentifierTreeImpl)expressionTree;
            SymbolImpl receiverSymbol = receiver.symbol();
            if (receiverSymbol == null) {
                return null;
            }
            Tree receiverDeclarationParent = receiverSymbol.declaration().getParent();
            if (!receiverDeclarationParent.is(Tree.Kind.PARAMETER)) {
                return null;
            }
            className = this.parameterType((ParameterTree)receiverDeclarationParent);
        }
        if (className == null) {
            return null;
        }
        return (className + "::" + CheckUtils.functionName(tree)).toLowerCase(Locale.ROOT);
    }

    private static Optional<CallArgumentTree> getLaravelValidationsArgument(FunctionCallTree tree, String fullFunctionName) {
        if (LARAVEL_RULES_ARGUMENT.containsKey(fullFunctionName) && (!"validator".equals(fullFunctionName) || RequestContentLengthCheck.isInLaravelController(tree))) {
            return CheckUtils.argument(tree, LARAVEL_RULES_KEY, LARAVEL_RULES_ARGUMENT.get(fullFunctionName));
        }
        return Optional.empty();
    }

    private static boolean isInLaravelController(FunctionCallTree tree) {
        ClassSymbol classSymbol;
        Tree classDeclaration = TreeUtils.findAncestorWithKind((Tree)tree, Collections.singletonList(Tree.Kind.CLASS_DECLARATION));
        if (classDeclaration != null && (classSymbol = Symbols.get((ClassDeclarationTree)classDeclaration)) != null) {
            return classSymbol.isSubTypeOf(LARAVEL_CONTROLLER).isTrue();
        }
        return false;
    }

    private static Stream<LaravelFileValidation> getLaravelFileValidations(ArrayInitializerTree tree) {
        return tree.arrayPairs().stream().map(ArrayPairTree::value).map(LaravelFileValidation::of).filter(Objects::nonNull);
    }

    @Nullable
    private String parameterType(ParameterTree parameter) {
        TypeNameTree typeNameTree;
        if (parameter.declaredType() != null && parameter.declaredType().isSimple() && (typeNameTree = ((TypeTree)parameter.declaredType()).typeName()).is(Tree.Kind.NAMESPACE_NAME)) {
            return this.getFullyQualifiedName((NamespaceNameTree)typeNameTree).toString();
        }
        return null;
    }

    private void checkSymfonyFileConstraint(ExpressionTree tree) {
        ExpressionTree value = CheckUtils.assignedValue(tree);
        if (!value.is(ARRAY)) {
            return;
        }
        Optional<ExpressionTree> setSize = CheckUtils.arrayValue((ArrayInitializerTree)value, "maxSize");
        if (setSize.isPresent()) {
            this.checkFileSize(setSize.get());
        } else {
            this.context().newIssue(this, value, MESSAGE);
        }
    }

    private void checkFileSize(ExpressionTree size) {
        ExpressionTree sizeValue = CheckUtils.assignedValue(size);
        long setBytes = 0L;
        if (sizeValue.is(Tree.Kind.NUMERIC_LITERAL, Tree.Kind.REGULAR_STRING_LITERAL)) {
            String unit;
            Matcher matcher = SIZE_FORMAT.matcher(sizeValue.is(Tree.Kind.REGULAR_STRING_LITERAL) ? CheckUtils.trimQuotes((LiteralTree)sizeValue) : ((LiteralTree)sizeValue).value());
            if (!matcher.matches()) {
                return;
            }
            setBytes = Long.parseLong(matcher.group("number"));
            switch (unit = matcher.group("unit") != null ? matcher.group("unit") : "") {
                case "k": {
                    setBytes *= 1000L;
                    break;
                }
                case "M": {
                    setBytes *= 1000000L;
                    break;
                }
                case "Ki": {
                    setBytes *= 1024L;
                    break;
                }
                case "Mi": {
                    setBytes *= 0x100000L;
                    break;
                }
            }
        } else if (sizeValue.is(Tree.Kind.NULL_LITERAL)) {
            setBytes = this.fileUploadSizeLimit + 1L;
        }
        if (setBytes > this.fileUploadSizeLimit) {
            this.context().newIssue(this, sizeValue, MESSAGE);
        }
    }

    private boolean isInstantiationOf(NewExpressionTree tree, QualifiedName name) {
        ExpressionTree expression = tree.expression();
        if (!expression.is(Tree.Kind.FUNCTION_CALL) || !((FunctionCallTree)expression).callee().is(Tree.Kind.NAMESPACE_NAME)) {
            return false;
        }
        return name.equals(this.getFullyQualifiedName((NamespaceNameTree)((FunctionCallTree)expression).callee()));
    }

    static {
        LARAVEL_RULES_ARGUMENT.put("illuminate\\http\\request::validate", 0);
        LARAVEL_RULES_ARGUMENT.put("illuminate\\http\\request::validatewithbag", 1);
        LARAVEL_RULES_ARGUMENT.put("validator", 1);
        LARAVEL_RULES_ARGUMENT.put("illuminate\\support\\facades\\validator::make", 1);
    }

    private static class LaravelFileValidation {
        ExpressionTree definition;
        Long maxBytes;

        public LaravelFileValidation(ExpressionTree definition, @Nullable Long maxBytes) {
            this.definition = definition;
            this.maxBytes = maxBytes;
        }

        @Nullable
        private static LaravelFileValidation of(ExpressionTree tree) {
            Set<String> validationValues = new HashSet<String>();
            if (tree.is(Tree.Kind.REGULAR_STRING_LITERAL)) {
                Collections.addAll(validationValues, CheckUtils.trimQuotes((LiteralTree)tree).split("\\|"));
            } else if (tree.is(ARRAY)) {
                validationValues = ((ArrayInitializerTree)tree).arrayPairs().stream().map(ArrayPairTree::value).filter(v -> v.is(Tree.Kind.REGULAR_STRING_LITERAL)).map(v -> CheckUtils.trimQuotes((LiteralTree)v)).collect(Collectors.toSet());
            }
            return LaravelFileValidation.ofArray(tree, validationValues);
        }

        @Nullable
        private static LaravelFileValidation ofArray(ExpressionTree definition, Set<String> validationValues) {
            if (!validationValues.contains("file")) {
                return null;
            }
            Long size = validationValues.stream().map(LARAVEL_SIZE_FORMAT::matcher).filter(Matcher::matches).map(m -> Long.parseLong(m.group("size")) * 1000L).findFirst().orElse(null);
            return new LaravelFileValidation(definition, size);
        }

        public boolean isMaxHigher(long v) {
            return this.maxBytes == null || this.maxBytes > v;
        }
    }
}

