/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils.type;

import org.sonar.plugins.php.api.symbols.QualifiedName;

public class StaticFunctionCall {
    private QualifiedName callee;
    private String functionName;

    private StaticFunctionCall(QualifiedName callee, String functionName) {
        this.callee = callee;
        this.functionName = functionName;
    }

    public boolean matches(QualifiedName className, String memberName) {
        return this.functionName.equalsIgnoreCase(memberName) && this.callee.equals(className);
    }

    public static StaticFunctionCall staticFunctionCall(String qualifiedFunctionCall) {
        int i = qualifiedFunctionCall.indexOf("::");
        if (i < 0) {
            throw new IllegalStateException("StaticFunctionCall notation must contain the \"::\" separator");
        }
        QualifiedName name = QualifiedName.qualifiedName(qualifiedFunctionCall.substring(0, i));
        return new StaticFunctionCall(name, qualifiedFunctionCall.substring(i + 2));
    }
}

