/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.expression;

import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.symbols.FunctionSymbol;
import org.sonar.php.symbols.UnknownFunctionSymbol;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.SeparatedListImpl;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class FunctionCallTreeImpl
extends PHPTree
implements FunctionCallTree {
    private static final Tree.Kind KIND = Tree.Kind.FUNCTION_CALL;
    private static final QualifiedName UNKNOWN_FUNCTION_NAME = QualifiedName.qualifiedName("<unknown_function>");
    private ExpressionTree callee;
    private final InternalSyntaxToken openParenthesisToken;
    private final SeparatedListImpl<ExpressionTree> arguments;
    private final SeparatedList<CallArgumentTree> callArguments;
    private final InternalSyntaxToken closeParenthesisToken;
    private FunctionSymbol symbol = new UnknownFunctionSymbol(UNKNOWN_FUNCTION_NAME);

    public FunctionCallTreeImpl(ExpressionTree callee, InternalSyntaxToken openParenthesisToken, SeparatedListImpl<CallArgumentTree> callArguments, InternalSyntaxToken closeParenthesisToken) {
        this.callee = callee;
        this.openParenthesisToken = openParenthesisToken;
        this.arguments = FunctionCallTreeImpl.argumentsValueList(callArguments);
        this.callArguments = callArguments;
        this.closeParenthesisToken = closeParenthesisToken;
    }

    public FunctionCallTreeImpl(ExpressionTree callee, SeparatedListImpl<CallArgumentTree> callArguments) {
        this.callee = callee;
        this.openParenthesisToken = null;
        this.arguments = FunctionCallTreeImpl.argumentsValueList(callArguments);
        this.callArguments = callArguments;
        this.closeParenthesisToken = null;
    }

    public FunctionCallTreeImpl(InternalSyntaxToken openParenthesisToken, SeparatedListImpl<CallArgumentTree> callArguments, InternalSyntaxToken closeParenthesisToken) {
        this.openParenthesisToken = openParenthesisToken;
        this.arguments = FunctionCallTreeImpl.argumentsValueList(callArguments);
        this.callArguments = callArguments;
        this.closeParenthesisToken = closeParenthesisToken;
    }

    public FunctionCallTreeImpl complete(ExpressionTree callee) {
        this.callee = callee;
        return this;
    }

    private static SeparatedListImpl<ExpressionTree> argumentsValueList(SeparatedListImpl<CallArgumentTree> arguments) {
        List<ExpressionTree> argumentValues = arguments.stream().map(CallArgumentTree::value).toList();
        return new SeparatedListImpl<ExpressionTree>(argumentValues, arguments.getSeparators());
    }

    @Override
    public ExpressionTree callee() {
        return this.callee;
    }

    @Override
    @Nullable
    public SyntaxToken openParenthesisToken() {
        return this.openParenthesisToken;
    }

    @Deprecated
    public SeparatedListImpl<ExpressionTree> arguments() {
        return this.arguments;
    }

    @Override
    public SeparatedList<CallArgumentTree> callArguments() {
        return this.callArguments;
    }

    @Override
    @Nullable
    public SyntaxToken closeParenthesisToken() {
        return this.closeParenthesisToken;
    }

    @Override
    public Tree.Kind getKind() {
        return KIND;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(IteratorUtils.iteratorOf(this.callee), IteratorUtils.iteratorOf(this.openParenthesisToken), this.callArguments.elementsAndSeparators(), IteratorUtils.iteratorOf(this.closeParenthesisToken));
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitFunctionCall(this);
    }

    public FunctionSymbol symbol() {
        return this.symbol;
    }

    public void setSymbol(FunctionSymbol symbol) {
        this.symbol = symbol;
    }
}

