/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.impl.statement;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.tree.impl.lexical.InternalSyntaxToken;
import org.sonar.php.utils.collections.IteratorUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.ParenthesisedExpressionTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.php.api.tree.statement.StatementTree;
import org.sonar.plugins.php.api.tree.statement.WhileStatementTree;
import org.sonar.plugins.php.api.visitors.VisitorCheck;

public class WhileStatementTreeImpl
extends PHPTree
implements WhileStatementTree {
    private final Tree.Kind kind;
    private final InternalSyntaxToken whileToken;
    private final ParenthesisedExpressionTree condition;
    private final InternalSyntaxToken colonToken;
    private final List<StatementTree> statements;
    private final InternalSyntaxToken endwhileToken;
    private final InternalSyntaxToken eosToken;

    public WhileStatementTreeImpl(InternalSyntaxToken whileToken, ParenthesisedExpressionTree condition, StatementTree statement) {
        this.kind = Tree.Kind.WHILE_STATEMENT;
        this.whileToken = whileToken;
        this.condition = condition;
        this.statements = Collections.singletonList(statement);
        this.colonToken = null;
        this.endwhileToken = null;
        this.eosToken = null;
    }

    public WhileStatementTreeImpl(InternalSyntaxToken whileToken, ParenthesisedExpressionTree condition, InternalSyntaxToken colonToken, List<StatementTree> statements, InternalSyntaxToken endwhileToken, InternalSyntaxToken eosToken) {
        this.kind = Tree.Kind.ALTERNATIVE_WHILE_STATEMENT;
        this.whileToken = whileToken;
        this.condition = condition;
        this.statements = statements;
        this.colonToken = colonToken;
        this.endwhileToken = endwhileToken;
        this.eosToken = eosToken;
    }

    @Override
    public Tree.Kind getKind() {
        return this.kind;
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return IteratorUtils.concat(IteratorUtils.iteratorOf(this.whileToken, this.condition, this.colonToken), this.statements.iterator(), IteratorUtils.iteratorOf(this.endwhileToken, this.eosToken));
    }

    @Override
    public SyntaxToken whileToken() {
        return this.whileToken;
    }

    @Override
    public ParenthesisedExpressionTree condition() {
        return this.condition;
    }

    @Override
    @Nullable
    public SyntaxToken colonToken() {
        return this.colonToken;
    }

    @Override
    public List<StatementTree> statements() {
        return this.statements;
    }

    @Override
    @Nullable
    public SyntaxToken endWhileToken() {
        return this.endwhileToken;
    }

    @Override
    @Nullable
    public SyntaxToken eosToken() {
        return this.eosToken;
    }

    @Override
    public void accept(VisitorCheck visitor) {
        visitor.visitWhileStatement(this);
    }
}

