/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree.symbols;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.sonar.api.utils.Preconditions;
import org.sonar.php.tree.symbols.Scope;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.symbols.Symbol;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxToken;

public class SymbolImpl
implements Symbol {
    private final String name;
    private final IdentifierTree declaration;
    private QualifiedName qualifiedName;
    private Symbol.Kind kind;
    private Scope scope;
    private List<SyntaxToken> usages = new LinkedList<SyntaxToken>();
    private List<SyntaxToken> modifiers = new LinkedList<SyntaxToken>();
    private List<ExpressionTree> assignedValues = new LinkedList<ExpressionTree>();
    private boolean assignedUnknown = false;

    SymbolImpl(IdentifierTree declaration, Symbol.Kind kind, Scope scope) {
        Preconditions.checkState(!kind.hasQualifiedName(), "Declaration of %s should provide qualified name", declaration);
        this.declaration = declaration;
        this.name = declaration.text();
        this.kind = kind;
        this.scope = scope;
    }

    SymbolImpl(IdentifierTree declaration, Symbol.Kind kind, Scope scope, QualifiedName qualifiedName) {
        Preconditions.checkState(kind.hasQualifiedName(), "Declaration %s can not have qualified name %s", declaration, qualifiedName);
        this.declaration = declaration;
        this.name = qualifiedName.simpleName();
        this.qualifiedName = qualifiedName;
        this.kind = kind;
        this.scope = scope;
    }

    SymbolImpl(QualifiedName qualifiedName, Symbol.Kind kind) {
        this.name = qualifiedName.simpleName();
        this.qualifiedName = qualifiedName;
        this.kind = kind;
        this.declaration = null;
    }

    @Override
    public List<SyntaxToken> modifiers() {
        return this.modifiers;
    }

    @Override
    public boolean hasModifier(String modifier) {
        for (SyntaxToken syntaxToken : this.modifiers) {
            if (!syntaxToken.text().equalsIgnoreCase(modifier)) continue;
            return true;
        }
        return false;
    }

    void addModifiers(List<SyntaxToken> modifiers) {
        this.modifiers.addAll(modifiers);
    }

    void addUsage(SyntaxToken usage) {
        this.usages.add(usage);
    }

    void addUsage(IdentifierTree usage) {
        this.addUsage(usage.token());
    }

    @Override
    public List<SyntaxToken> usages() {
        return this.usages;
    }

    public Scope scope() {
        return this.scope;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public QualifiedName qualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public IdentifierTree declaration() {
        return this.declaration;
    }

    @Override
    public boolean is(Symbol.Kind kind) {
        return kind.equals((Object)this.kind);
    }

    @Override
    public boolean called(String name) {
        if (this.kind == Symbol.Kind.VARIABLE || this.kind == Symbol.Kind.PARAMETER || this.kind == Symbol.Kind.FIELD) {
            return name.equals(this.name);
        }
        return name.equalsIgnoreCase(this.name);
    }

    @Override
    public Symbol.Kind kind() {
        return this.kind;
    }

    public String toString() {
        return "SymbolImpl{name='" + this.name + "', qualifiedName='" + this.qualifiedName() + "', kind=" + this.kind + ", scope=" + this.scope + "}";
    }

    public void assignValue(ExpressionTree value) {
        this.assignedValues.add(value);
    }

    public void assignUnknown() {
        this.assignedUnknown = true;
    }

    public Optional<ExpressionTree> uniqueAssignedValue() {
        return !this.assignedUnknown && this.assignedValues.size() == 1 ? Optional.of(this.assignedValues.get(0)) : Optional.empty();
    }
}

