/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.utils.Version;
import org.sonarsource.analyzer.commons.FileProvider;

public final class ExternalReportWildcardProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ExternalReportWildcardProvider.class);
    private static final int MINIMUM_MAJOR_SUPPORTED_VERSION = 7;
    private static final int MINIMUM_MINOR_SUPPORTED_VERSION = 2;

    private ExternalReportWildcardProvider() {
    }

    public static List<File> getReportFiles(SensorContext context, String externalReportsProperty) {
        String[] reportPaths = context.config().getStringArray(externalReportsProperty);
        if (reportPaths.length == 0) {
            return Collections.emptyList();
        }
        Version minumumVersion = Version.create(7, 2);
        boolean externalIssuesSupported = context.runtime().getApiVersion().isGreaterThanOrEqual(minumumVersion);
        if (!externalIssuesSupported) {
            LOG.error("Import of external issues requires SonarQube 7.2 or greater.");
            return Collections.emptyList();
        }
        ArrayList<File> result = new ArrayList<File>();
        for (String reportPath : reportPaths) {
            try {
                List<File> reports = ExternalReportWildcardProvider.getIOFiles(context.fileSystem().baseDir(), reportPath);
                result.addAll(reports);
            }
            catch (IllegalStateException e) {
                LOG.debug("Exception when searching for report files to import.", e);
            }
        }
        return result;
    }

    private static boolean isWildcard(String path) {
        return path.contains("*") || path.contains("?");
    }

    private static List<File> getIOFiles(File baseDir, String reportPath) {
        if (!ExternalReportWildcardProvider.isWildcard(reportPath)) {
            return List.of(ExternalReportWildcardProvider.getSpecificFile(baseDir, reportPath));
        }
        FileProvider fileProvider = new FileProvider(baseDir, reportPath);
        return fileProvider.getMatchingFiles();
    }

    private static File getSpecificFile(File baseDir, String path) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            file = new File(baseDir, path);
        }
        return file;
    }
}

