/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.phpunit;

import com.ctc.wstx.exc.WstxIOException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import javax.xml.stream.XMLStreamException;
import org.codehaus.staxmate.SMInputFactory;
import org.codehaus.staxmate.in.SMHierarchicCursor;
import org.codehaus.staxmate.in.SMInputCursor;
import org.sonar.plugins.php.reports.phpunit.JUnitLogParserForPhpUnit;
import org.sonar.plugins.php.reports.phpunit.xml.CoverageNode;
import org.sonar.plugins.php.reports.phpunit.xml.FileNode;
import org.sonar.plugins.php.reports.phpunit.xml.LineNode;
import org.sonar.plugins.php.reports.phpunit.xml.PackageNode;
import org.sonar.plugins.php.reports.phpunit.xml.ProjectNode;
import org.sonarsource.analyzer.commons.xml.ParseException;

class CoverageFileParserForPhpUnit {
    CoverageFileParserForPhpUnit() {
    }

    protected void parse(File report, Consumer<FileNode> consumer) throws IOException {
        CoverageNode coverage = CoverageFileParserForPhpUnit.getCoverage(report);
        List<ProjectNode> projects = coverage.getProjects();
        if (!projects.isEmpty()) {
            ProjectNode projectNode = projects.get(0);
            CoverageFileParserForPhpUnit.parse(projectNode, consumer);
        }
    }

    private static void parse(ProjectNode projectNode, Consumer<FileNode> consumer) {
        CoverageFileParserForPhpUnit.consumeFileNodes(projectNode.getFiles(), consumer);
        CoverageFileParserForPhpUnit.parse(projectNode.getPackages(), consumer);
    }

    private static void consumeFileNodes(List<FileNode> fileNodes, Consumer<FileNode> consumer) {
        fileNodes.forEach(consumer);
    }

    private static void parse(List<PackageNode> packages, Consumer<FileNode> consumer) {
        for (PackageNode packageNode : packages) {
            CoverageFileParserForPhpUnit.consumeFileNodes(packageNode.getFiles(), consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CoverageNode getCoverage(File report) throws ParseException, IOException {
        CoverageNode coverageNode;
        block8: {
            SMInputFactory inputFactory = JUnitLogParserForPhpUnit.inputFactory();
            SMHierarchicCursor rootCursor = null;
            try {
                rootCursor = inputFactory.rootElementCursor(report);
                rootCursor.advance();
                if (!"coverage".equals(rootCursor.getLocalName())) {
                    throw new XMLStreamException("Report should start with <coverage>");
                }
                coverageNode = CoverageFileParserForPhpUnit.parseCoverageNode(rootCursor);
                if (rootCursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rootCursor != null) {
                        rootCursor.getStreamReader().closeCompletely();
                    }
                    throw throwable;
                }
                catch (WstxIOException e) {
                    throw new IOException(e.getMessage(), e.getCause());
                }
                catch (XMLStreamException e) {
                    throw new ParseException(e);
                }
            }
            rootCursor.getStreamReader().closeCompletely();
        }
        return coverageNode;
    }

    private static CoverageNode parseCoverageNode(SMHierarchicCursor cursor) throws XMLStreamException {
        CoverageNode result = new CoverageNode();
        SMInputCursor childCursor = cursor.childElementCursor("project");
        while (childCursor.getNext() != null) {
            result.getProjects().add(CoverageFileParserForPhpUnit.parseProjectNode(childCursor));
        }
        return result;
    }

    private static ProjectNode parseProjectNode(SMInputCursor cursor) throws XMLStreamException {
        ProjectNode result = new ProjectNode();
        result.setName(cursor.getAttrValue("name"));
        SMInputCursor childCursor = cursor.childElementCursor();
        while (childCursor.getNext() != null) {
            if ("package".equals(childCursor.getLocalName())) {
                result.getPackages().add(CoverageFileParserForPhpUnit.parsePackageNode(childCursor));
                continue;
            }
            if (!"file".equals(childCursor.getLocalName())) continue;
            result.getFiles().add(CoverageFileParserForPhpUnit.parseFileNode(childCursor));
        }
        return result;
    }

    private static PackageNode parsePackageNode(SMInputCursor cursor) throws XMLStreamException {
        PackageNode result = new PackageNode();
        result.setName(cursor.getAttrValue("name"));
        SMInputCursor childCursor = cursor.childElementCursor("file");
        while (childCursor.getNext() != null) {
            result.getFiles().add(CoverageFileParserForPhpUnit.parseFileNode(childCursor));
        }
        return result;
    }

    private static FileNode parseFileNode(SMInputCursor cursor) throws XMLStreamException {
        FileNode result = new FileNode();
        result.setName(cursor.getAttrValue("name"));
        SMInputCursor childCursor = cursor.childElementCursor("line");
        while (childCursor.getNext() != null) {
            result.getLines().add(CoverageFileParserForPhpUnit.parseLineNode(childCursor));
        }
        return result;
    }

    private static LineNode parseLineNode(SMInputCursor cursor) throws XMLStreamException {
        int count = CoverageFileParserForPhpUnit.attributeIntValue(cursor, "count");
        int num = CoverageFileParserForPhpUnit.attributeIntValue(cursor, "num");
        String type = cursor.getAttrValue("type");
        return new LineNode(count, num, type);
    }

    private static int attributeIntValue(SMInputCursor cursor, String name) throws XMLStreamException {
        return Integer.parseInt(cursor.getAttrValue(name));
    }
}

