/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.phpunit;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FilePredicate;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.Sensor;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.plugins.php.reports.phpunit.CoverageResultImporter;
import org.sonar.plugins.php.reports.phpunit.TestResultImporter;
import org.sonar.plugins.php.warning.AnalysisWarningsWrapper;

public class PhpUnitSensor
implements Sensor {
    public static final String PHPUNIT_COVERAGE_REPORT_PATHS_KEY = "sonar.php.coverage.reportPaths";
    public static final String PHPUNIT_TESTS_REPORT_PATH_KEY = "sonar.php.tests.reportPath";
    private static final Logger LOG = LoggerFactory.getLogger(PhpUnitSensor.class);
    private static final FilePredicate PHPUNIT_TEST_FILE_PREDICATE = new TestCaseFilePredicate();
    private final TestResultImporter testResultImporter;
    private final CoverageResultImporter coverageResultImporter;

    public PhpUnitSensor(AnalysisWarningsWrapper analysisWarningsWrapper) {
        this.testResultImporter = new TestResultImporter(analysisWarningsWrapper);
        this.coverageResultImporter = new CoverageResultImporter(analysisWarningsWrapper);
    }

    @Override
    public void describe(SensorDescriptor descriptor) {
        descriptor.onlyOnLanguage("php").name("PHPUnit report sensor");
    }

    @Override
    public void execute(SensorContext context) {
        this.testResultImporter.execute(context);
        this.coverageResultImporter.execute(context);
        if (!context.config().hasKey("sonar.tests")) {
            PhpUnitSensor.detectUndeclaredTestCases(context);
        }
    }

    private static void detectUndeclaredTestCases(SensorContext context) {
        FileSystem fs = context.fileSystem();
        Iterator<InputFile> inputFiles = fs.inputFiles(fs.predicates().and(fs.predicates().hasLanguage("php"), PHPUNIT_TEST_FILE_PREDICATE)).iterator();
        if (inputFiles.hasNext()) {
            LOG.warn("PHPUnit test cases are detected. Make sure to specify test sources via `sonar.test` to get more precise analysis results.");
        }
        while (inputFiles.hasNext()) {
            LOG.debug("Detected and undeclared test case in: {}", (Object)inputFiles.next().uri());
        }
    }

    static class TestCaseFilePredicate
    implements FilePredicate {
        private static final int DEFAULT_BUFFER_SIZE = 1024;
        private static final String PHPUNIT_TEST_CASE_FQN = "PHPUnit\\Framework\\TestCase";

        TestCaseFilePredicate() {
        }

        @Override
        public boolean apply(InputFile inputFile) {
            boolean bl;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputFile.inputStream());
            try {
                byte[] bytes = bufferedInputStream.readNBytes(1024);
                String text = new String(bytes, inputFile.charset());
                bl = text.contains(PHPUNIT_TEST_CASE_FQN);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.debug("Can not read file: {}", (Object)inputFile.uri());
                    return false;
                }
            }
            bufferedInputStream.close();
            return bl;
        }
    }
}

