/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.analyzer.commons.checks.verifier.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.sonarsource.analyzer.commons.checks.verifier.quickfix.TextEdit;
import org.sonarsource.analyzer.commons.checks.verifier.quickfix.TextSpan;

public class QuickFix {
    private final String description;
    private final List<TextEdit> textEdits;

    private QuickFix(String description, List<TextEdit> textEdits) {
        this.description = description;
        this.textEdits = textEdits;
    }

    public String getDescription() {
        return this.description;
    }

    public List<TextEdit> getTextEdits() {
        return this.textEdits;
    }

    public String toString() {
        return "[[QuickFix: " + this.description + "]]\n Edits: \n" + this.textEdits.stream().map(TextEdit::toString).collect(Collectors.joining("\n"));
    }

    public static Builder newQuickFix(String description) {
        return new Builder(description);
    }

    public static Builder newQuickFix(String description, Object ... args) {
        return new Builder(String.format(description, args));
    }

    public static class Builder {
        private final String description;
        private final List<TextEdit> textEdits = new ArrayList<TextEdit>();

        private Builder(String description) {
            this.description = description;
        }

        public Builder addTextEdit(TextEdit ... textEdit) {
            this.textEdits.addAll(Arrays.asList(textEdit));
            return this;
        }

        public Builder addTextEdit(int startLine, int startCharacter, int endLine, int endCharacter, String replacement) {
            this.textEdits.add(TextEdit.replaceTextSpan(new TextSpan(startLine, startCharacter, endLine, endCharacter), replacement));
            return this;
        }

        public Builder addTextEdits(List<TextEdit> textEdits) {
            this.textEdits.addAll(textEdits);
            return this;
        }

        public Builder reverseSortEdits() {
            this.textEdits.sort(new Sorter().reversed());
            return this;
        }

        public QuickFix build() {
            return new QuickFix(this.description, this.textEdits);
        }

        private static class Sorter
        implements Comparator<TextEdit> {
            private Sorter() {
            }

            @Override
            public int compare(TextEdit a, TextEdit b) {
                TextSpan first = a.getTextSpan();
                TextSpan second = b.getTextSpan();
                int result = first.startLine - second.startLine;
                if (result != 0) {
                    return result;
                }
                result = first.startCharacter - second.startCharacter;
                if (result != 0) {
                    return result;
                }
                result = first.endLine - second.endLine;
                if (result != 0) {
                    return result;
                }
                return first.endCharacter - second.endCharacter;
            }
        }
    }
}

