/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.volume.condition.Condition;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionExtractorBase;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CLikeConditionExtractor
extends ConditionExtractorBase {
    public CLikeConditionExtractor(ELanguage language) {
        super(CLikeConditionExtractor.getBooleanResultOperators(language));
    }

    private static Set<ETokenType> getBooleanResultOperators(ELanguage language) {
        EnumSet<ETokenType[]> operators = EnumSet.of(ETokenType.ANDAND, new ETokenType[]{ETokenType.OROR, ETokenType.EQEQ, ETokenType.NOTEQ, ETokenType.LT, ETokenType.GT, ETokenType.LTEQ, ETokenType.GTEQ, ETokenType.NOT});
        if (language == ELanguage.JAVA || language == ELanguage.CS) {
            operators.add((ETokenType[])ETokenType.OR);
            operators.add((ETokenType[])ETokenType.AND);
        } else if (language == ELanguage.JAVASCRIPT) {
            operators.add((ETokenType[])ETokenType.EQEQEQ);
            operators.add((ETokenType[])ETokenType.NOTEQEQ);
        }
        return operators;
    }

    @Override
    public Condition extractCondition(ShallowEntity entity) {
        if (entity.hasChildren() && ((ShallowEntity)entity.getChildren().get(0)).getType() == EShallowEntityType.METHOD) {
            return null;
        }
        switch (entity.getSubtype()) {
            case "if": 
            case "else if": 
            case "while": {
                return CLikeConditionExtractor.extractConditionInParenthesis((List<IToken>)entity.ownStartTokens());
            }
            case "do": {
                return CLikeConditionExtractor.extractConditionInParenthesis(CLikeConditionExtractor.getDoWhileConditionTokens(entity));
            }
            case "for": {
                return CLikeConditionExtractor.extractConditionInSemicolons((List<IToken>)entity.ownStartTokens());
            }
        }
        return null;
    }

    private static Condition extractConditionInParenthesis(List<IToken> tokens) {
        int openingIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.LPAREN);
        int closingIndex = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(openingIndex + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (openingIndex == -1 || closingIndex == -1) {
            return null;
        }
        return new Condition(tokens.subList(openingIndex + 1, closingIndex));
    }

    private static Condition extractConditionInSemicolons(List<IToken> tokens) {
        int firstSemicolon = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.SEMICOLON);
        int secondSemicolon = TokenStreamUtils.firstTokenMatching(tokens, (int)(firstSemicolon + 1), (ITokenMatcher)ETokenType.SEMICOLON);
        if (firstSemicolon == -1 || secondSemicolon == -1) {
            return null;
        }
        return new Condition(tokens.subList(firstSemicolon + 1, secondSemicolon));
    }

    @Override
    protected boolean isDoubleOperator(ETokenType type1, ETokenType type2) {
        return type1 == ETokenType.LT && type2 == ETokenType.LT || type1 == ETokenType.GT && type2 == ETokenType.GT;
    }

    @Override
    protected void extractGeneralConditionWithoutCall(List<IToken> tokens, List<Condition> conditions) {
        int currentStart = 0;
        for (int i = 0; i < tokens.size(); ++i) {
            ETokenType type = tokens.get(i).getType();
            if (type != ETokenType.QUESTION && type != ETokenType.COLON) continue;
            if (i > currentStart) {
                super.extractGeneralConditionWithoutCall(tokens.subList(currentStart, i), conditions);
            }
            currentStart = i + 1;
        }
        if (tokens.size() > currentStart) {
            super.extractGeneralConditionWithoutCall(tokens.subList(currentStart, tokens.size()), conditions);
        }
    }

    private static List<IToken> getDoWhileConditionTokens(ShallowEntity entity) {
        if (entity.hasChildren()) {
            return entity.ownEndTokens();
        }
        UnmodifiableList tokens = entity.ownStartTokens();
        int splitIndex = TokenStreamUtils.lastTokenMatching((List)tokens, (ITokenMatcher)ETokenType.WHILE);
        return tokens.subList(splitIndex, tokens.size());
    }
}

