/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionEvaluatorBase;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionInnerTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeFalse;
import org.conqat.engine.sourcecode.coverage.volume.condition.ConditionTreeNodeTrue;
import org.conqat.engine.sourcecode.coverage.volume.condition.ExpressionTreeNode;
import org.conqat.engine.sourcecode.coverage.volume.condition.IConditionTreeNode;

class ConditionTreeNodeLeaf
implements IConditionTreeNode {
    private final ConditionEvaluatorBase conditionEvaluator;
    private final ExpressionTreeNode expression;

    ConditionTreeNodeLeaf(ExpressionTreeNode expression, ConditionEvaluatorBase conditionEvaluator) {
        this.conditionEvaluator = conditionEvaluator;
        this.expression = expression;
    }

    @Override
    public IConditionTreeNode expand() {
        ETokenType operator = this.expression.getOperator();
        if (operator != null && this.conditionEvaluator.getBooleanOperators().contains(operator)) {
            if (this.expression.getOperator() == ETokenType.GT && this.expression.getChildren().size() == 2) {
                operator = ConditionTreeNodeLeaf.replaceOperatorAndSwapOperands(this.expression, ETokenType.LT);
            } else if (this.expression.getOperator() == ETokenType.GTEQ && this.expression.getChildren().size() == 2) {
                operator = ConditionTreeNodeLeaf.replaceOperatorAndSwapOperands(this.expression, ETokenType.LTEQ);
            }
            return new ConditionInnerTreeNode(operator, this.conditionEvaluator, this.expression.getChildren()).expand();
        }
        return this;
    }

    private static ETokenType replaceOperatorAndSwapOperands(ExpressionTreeNode node, ETokenType operator) {
        node.setChildren(List.of(node.getChildren().get(1), node.getChildren().get(0)));
        node.operator = operator;
        return node.operator;
    }

    @Override
    public boolean isKeyword() {
        return this.expression.getExpression().size() == 1 && this.expression.getExpression().get(0).getType().isKeyword();
    }

    @Override
    public IConditionTreeNode toCnf() {
        List<IToken> tokens = this.expression.getExpression();
        if (tokens.size() == 1) {
            IToken token = tokens.get(0);
            ETokenType tokenType = token.getType();
            if (tokenType == ETokenType.TRUE || tokenType == ETokenType.BOOLEAN_LITERAL && token.getText().equalsIgnoreCase("true")) {
                return new ConditionTreeNodeTrue();
            }
            if (tokenType == ETokenType.FALSE || tokenType == ETokenType.BOOLEAN_LITERAL && token.getText().equalsIgnoreCase("false")) {
                return new ConditionTreeNodeFalse();
            }
        }
        return this;
    }

    @Override
    public IConditionTreeNode simplify() {
        return this.toCnf();
    }

    @Override
    public IConditionTreeNode negateNode() {
        return this.conditionEvaluator.addNegation(this);
    }

    @Override
    public IConditionTreeNode castToBoolean() {
        if (this.expression != null && this.conditionEvaluator.supportsImplicitBooleanCast()) {
            return this.conditionEvaluator.castToBoolean(this, this.expression);
        }
        return this;
    }

    @Override
    public boolean contains(IConditionTreeNode node) {
        return false;
    }

    @Override
    public boolean isOpposite(IConditionTreeNode node) {
        if (node instanceof ConditionInnerTreeNode && node.getOperator() == ConditionEvaluatorBase.getNegationOperator()) {
            return ((ConditionInnerTreeNode)node).getSingleChild().equals(this);
        }
        return false;
    }

    @Override
    public ETokenType getOperator() {
        return null;
    }

    @Override
    public List<IConditionTreeNode> getChildren() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.expression.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ConditionTreeNodeLeaf) {
            return this.expression == null && ((ConditionTreeNodeLeaf)other).expression == null || this.expression != null && this.expression.equals(((ConditionTreeNodeLeaf)other).expression);
        }
        return false;
    }

    public int hashCode() {
        return this.expression.getExpression().size();
    }
}

