/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume.condition;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.volume.condition.Condition;
import org.conqat.engine.sourcecode.coverage.volume.condition.SubConditionParserBase;

public class SplitSubConditionParser
extends SubConditionParserBase {
    private final Set<ETokenType> splitTokenTypes;
    private final Set<ETokenType> topLevelSplitTokenTypes;

    public SplitSubConditionParser(Set<ETokenType> splitTokenTypes) {
        this(splitTokenTypes, EnumSet.noneOf(ETokenType.class));
    }

    public SplitSubConditionParser(Set<ETokenType> splitTokenTypes, Set<ETokenType> topLevelSplitTokenTypes) {
        this.splitTokenTypes = splitTokenTypes;
        this.topLevelSplitTokenTypes = topLevelSplitTokenTypes;
    }

    @Override
    public List<Condition> getSubConditions(Condition condition) {
        ArrayList<Condition> subConditions = new ArrayList<Condition>();
        Condition currentCondition = new Condition();
        int parenthesisNesting = 0;
        for (IToken token : condition.getTokens()) {
            ETokenType tokenType = token.getType();
            if (tokenType == ETokenType.LPAREN) {
                ++parenthesisNesting;
            } else if (tokenType == ETokenType.RPAREN) {
                --parenthesisNesting;
            }
            if (this.splitTokenTypes.contains(tokenType) || parenthesisNesting == 0 && this.topLevelSplitTokenTypes.contains(tokenType)) {
                SplitSubConditionParser.addConditionIfNotConstant(currentCondition, subConditions);
                currentCondition = new Condition();
                continue;
            }
            currentCondition.appendToken(token);
        }
        if (subConditions.isEmpty() || !currentCondition.isEmpty()) {
            SplitSubConditionParser.addConditionIfNotConstant(currentCondition, subConditions);
        }
        return subConditions;
    }

    private static void addConditionIfNotConstant(Condition condition, List<Condition> subConditions) {
        String tokenText;
        if ((condition = condition.cleanupParenthesesAndNegation()).isEmpty()) {
            return;
        }
        if (condition.getTokens().size() == 1 && ((tokenText = ((IToken)condition.getTokens().get(0)).getText().toLowerCase()).equals("true") || tokenText.equals("false"))) {
            return;
        }
        subConditions.add(condition);
    }
}

