/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.shallowparser.preprocessor.lcov;

import eu.cqse.check.framework.scanner.IToken;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.IntStream;
import org.conqat.engine.sourcecode.coverage.volume.CodeBranch;
import org.conqat.engine.sourcecode.shallowparser.preprocessor.ExclusionCounter;

public class GcovLcovExclusionFilter {
    private static final Pattern EXCLUSION_START_DIRECTIVE_PATTERN = GcovLcovExclusionFilter.compileMatcherPattern("(?:LCOV|GCOV|GCOVR)_EXCL_START");
    private static final Pattern EXCLUSION_STOP_DIRECTIVE_PATTERN = GcovLcovExclusionFilter.compileMatcherPattern("(?:LCOV|GCOV|GCOVR)_EXCL_STOP");
    private static final Pattern EXCLUDES_CURRENT_LINE_DIRECTIVE_PATTERN = GcovLcovExclusionFilter.compileMatcherPattern("(?:LCOV|GCOV|GCOVR)_EXCL_LINE");
    private static final Pattern BRANCH_EXCLUSION_START_DIRECTIVE_PATTERN = GcovLcovExclusionFilter.compileMatcherPattern("(?:LCOV|GCOV|GCOVR)_EXCL_BR_START");
    private static final Pattern BRANCH_EXCLUSION_STOP_DIRECTIVE_PATTERN = GcovLcovExclusionFilter.compileMatcherPattern("(?:LCOV|GCOV|GCOVR)_EXCL_BR_STOP");
    private static final Pattern BRANCH_EXCLUDES_CURRENT_LINE_DIRECTIVE_PATTERN = GcovLcovExclusionFilter.compileMatcherPattern("(?:LCOV|GCOV|GCOVR)_EXCL_BR_LINE");

    public static Set<Integer> computeExcludedLines(List<IToken> tokens, boolean enableBranchDirectives) {
        ExclusionCounter exclusionCounter = new ExclusionCounter();
        HashSet<Integer> excludedLineNumbers = new HashSet<Integer>();
        int currentExclusionRegionStartLineNumber = -1;
        for (IToken token : tokens) {
            if (GcovLcovExclusionFilter.startsExclusion(token, enableBranchDirectives)) {
                exclusionCounter.signalExclusionStart();
                currentExclusionRegionStartLineNumber = GcovLcovExclusionFilter.getTokenLineNumber(token);
                continue;
            }
            if (GcovLcovExclusionFilter.endsExclusion(token, enableBranchDirectives)) {
                boolean exclusionPreviouslyActive = exclusionCounter.isExclusionActive();
                exclusionCounter.signalExclusionEnd();
                if (!exclusionPreviouslyActive || exclusionCounter.isExclusionActive()) continue;
                IntStream.range(currentExclusionRegionStartLineNumber, GcovLcovExclusionFilter.getTokenLineNumber(token)).forEach(excludedLineNumbers::add);
                continue;
            }
            if (!GcovLcovExclusionFilter.excludesCurrentLine(token, enableBranchDirectives)) continue;
            excludedLineNumbers.add(GcovLcovExclusionFilter.getTokenLineNumber(token));
        }
        return excludedLineNumbers;
    }

    private static int getTokenLineNumber(IToken token) {
        return token.getLineNumber() + 1;
    }

    public static Set<CodeBranch> computeRetainedCodeBranches(List<IToken> tokens, List<CodeBranch> branches) {
        Set<Integer> excludedLines = GcovLcovExclusionFilter.computeExcludedLines(tokens, true);
        HashSet<CodeBranch> retainedCodeBranches = new HashSet<CodeBranch>(branches);
        retainedCodeBranches.removeIf(codeBranch -> excludedLines.contains(codeBranch.getEntity().getStartLine()));
        return retainedCodeBranches;
    }

    private static boolean startsExclusion(IToken token, boolean enableBranchDirectives) {
        return GcovLcovExclusionFilter.tokenMatches(token, EXCLUSION_START_DIRECTIVE_PATTERN) || enableBranchDirectives && GcovLcovExclusionFilter.tokenMatches(token, BRANCH_EXCLUSION_START_DIRECTIVE_PATTERN);
    }

    private static boolean endsExclusion(IToken token, boolean enableBranchDirectives) {
        return GcovLcovExclusionFilter.tokenMatches(token, EXCLUSION_STOP_DIRECTIVE_PATTERN) || enableBranchDirectives && GcovLcovExclusionFilter.tokenMatches(token, BRANCH_EXCLUSION_STOP_DIRECTIVE_PATTERN);
    }

    private static boolean excludesCurrentLine(IToken token, boolean enableBranchDirectives) {
        return GcovLcovExclusionFilter.tokenMatches(token, EXCLUDES_CURRENT_LINE_DIRECTIVE_PATTERN) || enableBranchDirectives && GcovLcovExclusionFilter.tokenMatches(token, BRANCH_EXCLUDES_CURRENT_LINE_DIRECTIVE_PATTERN);
    }

    private static boolean tokenMatches(IToken token, Pattern directive) {
        return directive.matcher(token.getText()).find();
    }

    private static Pattern compileMatcherPattern(String directive) {
        return Pattern.compile("(?i:\\b" + directive + "\\b)", 256);
    }
}

