/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.Properties;
import org.sonar.api.Property;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.config.Category;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.config.SubCategory;
import org.sonar.api.internal.apachecommons.lang.StringUtils;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.System2;

@ScannerSide
@ServerSide
@ComputeEngineSide
public final class PropertyDefinitions {
    private final Map<String, PropertyDefinition> definitions = new HashMap<String, PropertyDefinition>();
    private final Map<String, String> propertyValueFromEnvironment = new HashMap<String, String>();
    private final Map<String, Category> categories = new HashMap<String, Category>();
    private final Map<String, SubCategory> subcategories = new HashMap<String, SubCategory>();
    private final Map<String, String> deprecatedKeys = new HashMap<String, String>();
    private final System2 system;

    public PropertyDefinitions(System2 system, Object ... components) {
        this.system = system;
        this.addComponents(Arrays.asList(components));
    }

    public PropertyDefinitions(System2 system, Collection<PropertyDefinition> components) {
        this.system = system;
        this.addComponents(components);
    }

    public PropertyDefinitions addComponents(Collection components) {
        return this.addComponents(components, "");
    }

    public PropertyDefinitions addComponents(Collection components, String defaultCategory) {
        for (Object component : components) {
            this.addComponent(component, defaultCategory);
        }
        return this;
    }

    public PropertyDefinitions addComponent(Object object) {
        return this.addComponent(object, "");
    }

    public PropertyDefinitions addComponent(Object component, String defaultCategory) {
        this.addComponentFromAnnotationProperty(component, defaultCategory);
        if (component instanceof PropertyDefinition) {
            PropertyDefinition propertyDefinition = (PropertyDefinition)component;
            this.add(propertyDefinition, defaultCategory);
        }
        return this;
    }

    private PropertyDefinitions addComponentFromAnnotationProperty(Object component, String defaultCategory) {
        Property annotation;
        Properties annotations = AnnotationUtils.getAnnotation(component, Properties.class);
        if (annotations != null) {
            for (Property property : annotations.value()) {
                this.addProperty(property, defaultCategory);
            }
        }
        if ((annotation = AnnotationUtils.getAnnotation(component, Property.class)) != null) {
            this.addProperty(annotation, defaultCategory);
        }
        return this;
    }

    private PropertyDefinitions addProperty(Property property, String defaultCategory) {
        PropertyDefinition definition = PropertyDefinition.create(property);
        return this.add(definition, defaultCategory);
    }

    private PropertyDefinitions add(PropertyDefinition definition, String defaultCategory) {
        if (!this.definitions.containsKey(definition.key())) {
            this.definitions.put(definition.key(), definition);
            String envVar = definition.key().toUpperCase(Locale.ENGLISH).replace('.', '_').replace('-', '_');
            Optional.ofNullable(this.system.envVariable(envVar)).ifPresent(value -> this.propertyValueFromEnvironment.put(definition.key(), (String)value));
            String category = StringUtils.defaultIfBlank(definition.category(), defaultCategory);
            this.categories.put(definition.key(), new Category(category));
            String subcategory = StringUtils.defaultIfBlank(definition.subCategory(), category);
            this.subcategories.put(definition.key(), new SubCategory(subcategory));
            if (!StringUtils.isEmpty(definition.deprecatedKey()) && !definition.deprecatedKey().equals(definition.key())) {
                this.deprecatedKeys.put(definition.deprecatedKey(), definition.key());
            }
        }
        return this;
    }

    @CheckForNull
    public PropertyDefinition get(String key) {
        return this.definitions.get(this.validKey(key));
    }

    public Optional<String> getValueFromEnv(String key) {
        return Optional.ofNullable(this.propertyValueFromEnvironment.get(key));
    }

    public Map<String, String> getAllPropertiesSetInEnv() {
        return new HashMap<String, String>(this.propertyValueFromEnvironment);
    }

    public Collection<PropertyDefinition> getAll() {
        return this.definitions.values();
    }

    public String validKey(String key) {
        Objects.requireNonNull(key, "key can't be null");
        String trimmedKey = key.trim();
        return StringUtils.defaultString(this.deprecatedKeys.get(trimmedKey), trimmedKey);
    }

    public Map<Category, Map<SubCategory, Collection<PropertyDefinition>>> propertiesByCategory(@Nullable String qualifier) {
        HashMap<Category, Map<SubCategory, Collection<PropertyDefinition>>> byCategory = new HashMap<Category, Map<SubCategory, Collection<PropertyDefinition>>>();
        if (qualifier == null) {
            HashMap emailSubCategories = new HashMap();
            emailSubCategories.put(new SubCategory("email", true), new ArrayList());
            byCategory.put(new Category("general", false), emailSubCategories);
            HashMap licenseSubCategories = new HashMap();
            licenseSubCategories.put(new SubCategory("server_id", true), new ArrayList());
            byCategory.put(new Category("licenses", false), licenseSubCategories);
            HashMap encryptionSubCategories = new HashMap();
            encryptionSubCategories.put(new SubCategory("encryption", true), new ArrayList());
            byCategory.put(new Category("security", false), encryptionSubCategories);
        }
        for (PropertyDefinition definition : this.getAll()) {
            if (!(qualifier == null ? definition.global() : definition.qualifiers().contains(qualifier))) continue;
            Category category = this.categories.get(definition.key());
            if (!byCategory.containsKey(category)) {
                byCategory.put(category, new HashMap());
            }
            SubCategory subCategory = this.subcategories.get(definition.key());
            if (!((Map)byCategory.get(category)).containsKey(subCategory)) {
                ((Map)byCategory.get(category)).put(subCategory, new ArrayList());
            }
            ((Collection)((Map)byCategory.get(category)).get(subCategory)).add(definition);
        }
        return byCategory;
    }

    @CheckForNull
    public String getDefaultValue(String key) {
        PropertyDefinition def = this.get(key);
        if (def == null) {
            return null;
        }
        return StringUtils.defaultIfEmpty(def.defaultValue(), null);
    }

    public String getCategory(String key) {
        return this.categories.get(this.validKey(key)).toString();
    }

    public String getSubCategory(String key) {
        return this.subcategories.get(this.validKey(key)).toString();
    }

    public String getCategory(Property prop) {
        return this.getCategory(prop.key());
    }

    public String getNewKey(String deprecatedKey) {
        return this.deprecatedKeys.get(deprecatedKey);
    }

    public String getDeprecatedKey(String key) {
        PropertyDefinition def = this.get(key);
        if (def == null) {
            return null;
        }
        return StringUtils.defaultIfEmpty(def.deprecatedKey(), null);
    }
}

