/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.command.Command;
import org.sonar.api.utils.command.CommandException;
import org.sonar.api.utils.command.CommandExecutor;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

public class NodeJsHelper {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final Pattern NODEJS_VERSION_PATTERN = Pattern.compile("v?(\\d+\\.\\d+\\.\\d+(-.*)?)");
    private final System2 system2;
    private final Path pathHelperLocationOnMac;
    private final CommandExecutor commandExecutor;
    private Path detectedNodePath;
    private Version nodeJsVersion;

    public NodeJsHelper() {
        this(System2.INSTANCE, Paths.get("/usr/libexec/path_helper", new String[0]), CommandExecutor.create());
    }

    NodeJsHelper(System2 system2, Path pathHelperLocationOnMac, CommandExecutor commandExecutor) {
        this.system2 = system2;
        this.pathHelperLocationOnMac = pathHelperLocationOnMac;
        this.commandExecutor = commandExecutor;
    }

    public void detect(@Nullable Path configuredNodejsPath) {
        this.detectedNodePath = this.locateNode(configuredNodejsPath);
        if (this.detectedNodePath != null) {
            LOG.debug("Checking node version...");
            Command command = Command.create(this.detectedNodePath.toString()).addArgument("-v");
            String nodeVersionStr = this.runSimpleCommand(command);
            if (nodeVersionStr != null) {
                Matcher matcher = NODEJS_VERSION_PATTERN.matcher(nodeVersionStr);
                if (matcher.matches()) {
                    String version = matcher.group(1);
                    this.nodeJsVersion = Version.create(version);
                    LOG.debug("Detected node version: {}", (Object)this.nodeJsVersion);
                } else {
                    LOG.debug("Unable to parse node version: {}", (Object)nodeVersionStr);
                }
            }
            if (this.nodeJsVersion == null) {
                LOG.warn("Unable to query node version");
            }
        }
    }

    @CheckForNull
    public Path getNodeJsPath() {
        return this.detectedNodePath;
    }

    @CheckForNull
    public Version getNodeJsVersion() {
        return this.nodeJsVersion;
    }

    @CheckForNull
    private Path locateNode(@Nullable Path configuredNodejsPath) {
        String result;
        if (configuredNodejsPath != null) {
            LOG.debug("Node.js path provided by configuration: {}", (Object)configuredNodejsPath);
            return configuredNodejsPath;
        }
        LOG.debug("Looking for node in the PATH");
        if (this.system2.isOsWindows()) {
            result = this.runSimpleCommand(Command.create("C:\\Windows\\System32\\where.exe").addArgument("$PATH:node.exe"));
        } else {
            Command which = Command.create("/usr/bin/which").addArgument("node");
            this.computePathEnvForMacOs(which);
            result = this.runSimpleCommand(which);
        }
        if (result != null) {
            LOG.debug("Found node at {}", (Object)result);
            return Paths.get(result, new String[0]);
        }
        LOG.debug("Unable to locate node");
        return null;
    }

    private void computePathEnvForMacOs(Command which) {
        Pattern regex;
        Matcher matchResult;
        Command command;
        String pathHelperOutput;
        if (this.system2.isOsMac() && Files.exists(this.pathHelperLocationOnMac, new LinkOption[0]) && (pathHelperOutput = this.runSimpleCommand(command = Command.create(this.pathHelperLocationOnMac.toString()).addArgument("-s"))) != null && (matchResult = (regex = Pattern.compile(".*PATH=\"(.*)\"; export PATH;.*")).matcher(pathHelperOutput)).matches()) {
            which.setEnvironmentVariable("PATH", matchResult.group(1));
        }
    }

    @CheckForNull
    private String runSimpleCommand(Command command) {
        int exitCode;
        ArrayList stdOut = new ArrayList();
        ArrayList stdErr = new ArrayList();
        LOG.debug("Execute command '{}'...", (Object)command);
        try {
            exitCode = this.commandExecutor.execute(command, stdOut::add, stdErr::add, 10000L);
        }
        catch (CommandException e) {
            LOG.debug("Unable to execute the command", (Object)e);
            return null;
        }
        StringBuilder msg = new StringBuilder(String.format("Command '%s' exited with %s", command.toString(), exitCode));
        if (!stdOut.isEmpty()) {
            msg.append("\nstdout: ").append(String.join((CharSequence)"\n", stdOut));
        }
        if (!stdErr.isEmpty()) {
            msg.append("\nstderr: ").append(String.join((CharSequence)"\n", stdErr));
        }
        LOG.debug(msg.toString());
        if (exitCode != 0 || stdOut.isEmpty()) {
            return null;
        }
        return (String)stdOut.get(0);
    }
}

